-- SchemaCrawler
-- http://www.schemacrawler.com
-- Copyright (c) 2000-2025, Sualeh Fatehi <sualeh@hotmail.com>.
-- All rights reserved.
-- SPDX-License-Identifier: EPL-2.0

SELECT
  NULLIF(1, 1)
    AS SEQUENCE_CATALOG,
  STRIP(SYSCAT.SEQUENCES.SEQSCHEMA)
    AS SEQUENCE_SCHEMA,
  STRIP(SYSCAT.SEQUENCES.SEQNAME)
    AS SEQUENCE_NAME,
  INCREMENT,
  START AS START_VALUE,
  MINVALUE AS MINIMUM_VALUE,
  MAXVALUE AS MAXIMUM_VALUE,
  CASE WHEN CYCLE = 'Y' THEN 'YES' ELSE 'NO' END AS CYCLE_OPTION,
  SEQID,
  SEQTYPE,
  NEXTCACHEFIRSTVALUE,
  CACHE,
  ORDER,
  CREATE_TIME,
  ALTER_TIME,
  REMARKS
FROM
  SYSCAT.SEQUENCES
WHERE
  SYSCAT.SEQUENCES.ORIGIN = 'U'
ORDER BY
  SYSCAT.SEQUENCES.SEQSCHEMA,
  SYSCAT.SEQUENCES.SEQNAME
WITH UR
