/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.bytecode;

import com.oracle.truffle.api.bytecode.BytecodeRootNodes;
import com.oracle.truffle.api.frame.FrameSlotKind;

public abstract class LocalVariable {
    protected LocalVariable(Object token) {
        BytecodeRootNodes.checkToken(token);
    }

    public int getStartIndex() {
        return -1;
    }

    public int getEndIndex() {
        return -1;
    }

    public abstract int getLocalOffset();

    public abstract int getLocalIndex();

    public abstract FrameSlotKind getTypeProfile();

    public abstract Object getInfo();

    public abstract Object getName();

    public String toString() {
        FrameSlotKind kind;
        Object info;
        StringBuilder b = new StringBuilder("LocalVariable[");
        int startIndex = this.getStartIndex();
        String sep = "";
        if (startIndex != -1) {
            b.append(String.format("%03x-%03x", this.getStartIndex(), this.getEndIndex()));
            sep = ", ";
        }
        b.append(sep);
        b.append("index=");
        b.append(this.getLocalIndex());
        b.append(", offset=");
        b.append(this.getLocalOffset());
        Object name = this.getName();
        if (name != null) {
            b.append(", name=");
            b.append(name);
        }
        if ((info = this.getInfo()) != null) {
            b.append(", info=");
            b.append(info);
        }
        if ((kind = this.getTypeProfile()) != null) {
            b.append(", profile=");
            b.append(kind.toString());
        }
        b.append("]");
        return b.toString();
    }
}

