/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.bytecode.SetupAwithNodeGen;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline(value=false)
public abstract class SetupAwithNode
extends PNodeWithContext {
    public abstract int execute(Frame var1, int var2);

    @Specialization
    static int setup(VirtualFrame frame, int stackTopIn, @Bind Node inliningTarget, @Cached GetClassNode getClassNode, @Cached LookupSpecialMethodNode.Dynamic lookupAEnter, @Cached LookupSpecialMethodNode.Dynamic lookupAExit, @Cached CallUnaryMethodNode callEnter, @Cached PRaiseNode raiseNode) {
        int stackTop = stackTopIn;
        Object contextManager = frame.getObject(stackTop);
        Object type = getClassNode.execute(inliningTarget, contextManager);
        Object enter = lookupAEnter.execute((Frame)frame, inliningTarget, type, SpecialMethodNames.T___AENTER__, contextManager);
        if (enter == PNone.NO_VALUE) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.N_OBJECT_DOES_NOT_SUPPORT_THE_ASYNC_CONTEXT_MANAGER_PROTOCOL, type);
        }
        Object exit = lookupAExit.execute((Frame)frame, inliningTarget, type, SpecialMethodNames.T___AEXIT__, contextManager);
        if (exit == PNone.NO_VALUE) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.N_OBJECT_DOES_NOT_SUPPORT_THE_ASYNC_CONTEXT_MANAGER_PROTOCOL_AEXIT, type);
        }
        Object res = callEnter.executeObject((Frame)frame, enter, contextManager);
        frame.setObject(++stackTop, exit);
        frame.setObject(++stackTop, res);
        return stackTop;
    }

    public static SetupAwithNode create() {
        return SetupAwithNodeGen.create();
    }

    public static SetupAwithNode getUncached() {
        return SetupAwithNodeGen.getUncached();
    }
}

