/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.complex.PComplex;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.lib.PyComplexCheckNode;
import com.oracle.graal.python.lib.PyNumberCheckNodeGen;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class PyNumberCheckNode
extends PNodeWithContext {
    public abstract boolean execute(Node var1, Object var2);

    public static boolean executeUncached(Object object) {
        return PyNumberCheckNodeGen.getUncached().execute(null, object);
    }

    @Specialization
    static boolean doString(TruffleString object) {
        return false;
    }

    @Specialization
    static boolean doDouble(Double object) {
        return true;
    }

    @Specialization
    static boolean doInt(Integer object) {
        return true;
    }

    @Specialization
    static boolean doLong(Long object) {
        return true;
    }

    @Specialization
    static boolean doBoolean(Boolean object) {
        return true;
    }

    @Specialization
    static boolean doNone(PNone object) {
        return false;
    }

    @Specialization
    static boolean doComplex(PComplex object) {
        return true;
    }

    @Fallback
    static boolean doOthers(Node inliningTarget, Object object, @Cached TpSlots.GetObjectSlotsNode getSlots, @Cached PyComplexCheckNode checkComplex) {
        TpSlots slots = getSlots.execute(inliningTarget, object);
        return slots.nb_index() != null || slots.nb_int() != null || slots.nb_float() != null || checkComplex.execute(inliningTarget, object);
    }
}

