/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.bz2;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.bz2.BZ2DecompressorBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.bz2.BZ2DecompressorBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.bz2.BZ2DecompressorBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.modules.bz2.BZ2Object;
import com.oracle.graal.python.builtins.modules.bz2.Bz2Nodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.NFIBz2Support;
import com.oracle.graal.python.runtime.NativeLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.BZ2Decompressor})
public final class BZ2DecompressorBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = BZ2DecompressorBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BZ2DecompressorBuiltinsFactory.getFactories();
    }

    @Builtin(name="eof", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class EOFNode
    extends PythonUnaryBuiltinNode {
        EOFNode() {
        }

        @Specialization
        boolean doit(BZ2Object.BZ2Decompressor self) {
            return self.isEOF();
        }
    }

    @Builtin(name="needs_input", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class NeedsInputNode
    extends PythonUnaryBuiltinNode {
        NeedsInputNode() {
        }

        @Specialization
        boolean doit(BZ2Object.BZ2Decompressor self) {
            return self.needsInput();
        }
    }

    @Builtin(name="unused_data", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class UnusedDataNode
    extends PythonUnaryBuiltinNode {
        UnusedDataNode() {
        }

        @Specialization
        static PBytes doit(BZ2Object.BZ2Decompressor self, @Bind PythonLanguage language) {
            return PFactory.createBytes(language, self.getUnusedData());
        }
    }

    @Builtin(name="decompress", minNumOfPositionalArgs=1, parameterNames={"$self", "data", "max_length"})
    @ArgumentClinic(name="max_length", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class DecompressNode
    extends PythonTernaryClinicBuiltinNode {
        DecompressNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BZ2DecompressorBuiltinsClinicProviders.DecompressNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!self.isEOF()"})
        static PBytes doNativeBytes(BZ2Object.BZ2Decompressor self, PBytesLike data, int maxLength, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached SequenceStorageNodes.GetInternalByteArrayNode toBytes, @Cached.Exclusive @Cached Bz2Nodes.Bz2NativeDecompress decompress) {
            BZ2Object.BZ2Decompressor bZ2Decompressor = self;
            synchronized (bZ2Decompressor) {
                byte[] bytes = toBytes.execute(inliningTarget, data.getSequenceStorage());
                int len = data.getSequenceStorage().length();
                return PFactory.createBytes(language, decompress.execute(inliningTarget, self, bytes, len, maxLength));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!self.isEOF()"})
        static PBytes doNativeObject(VirtualFrame frame, BZ2Object.BZ2Decompressor self, Object data, int maxLength, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached BytesNodes.ToBytesNode toBytes, @Cached.Exclusive @Cached Bz2Nodes.Bz2NativeDecompress decompress) {
            BZ2Object.BZ2Decompressor bZ2Decompressor = self;
            synchronized (bZ2Decompressor) {
                byte[] bytes = toBytes.execute(frame, data);
                int len = bytes.length;
                return PFactory.createBytes(language, decompress.execute(inliningTarget, self, bytes, len, maxLength));
            }
        }

        @Specialization(guards={"self.isEOF()"})
        static Object err(BZ2Object.BZ2Decompressor self, PBytesLike data, int maxLength, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.EOFError, ErrorMessages.END_OF_STREAM_ALREADY_REACHED);
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(name="BZDecompressor", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PNone init(BZ2Object.BZ2Decompressor self, @Bind Node inliningTarget, @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached NativeLibrary.InvokeNativeFunction compressInit, @Cached PRaiseNode raiseNode) {
            Object bzst;
            NFIBz2Support bz2Support = PythonContext.get(inliningTarget).getNFIBz2Support();
            int err = bz2Support.decompressInit(bzst = bz2Support.createStream(createStream), compressInit);
            if (err != 0) {
                Bz2Nodes.errorHandling(inliningTarget, err, raiseNode);
            }
            self.init(bzst, bz2Support);
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="BZ2Decompressor", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class BZ2DecompressorNode
    extends PythonBuiltinNode {
        @Specialization
        static BZ2Object.BZ2Decompressor doNew(Object cls, Object arg, @Bind PythonLanguage language) {
            return PFactory.createBZ2Decompressor(language);
        }
    }
}

