# The PEP 484 type hints stub file for the QtDataVisualization module.
#
# Generated by SIP 6.15.1
#
# Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt6-DataVisualization.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import collections, re, typing, enum

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt6.sip

from PyQt6 import QtCore
from PyQt6 import QtGui

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[collections.abc.Callable[..., Any], QtCore.pyqtBoundSignal]


class QAbstract3DGraph(QtGui.QWindow):

    class OptimizationHint(enum.Flag):
        OptimizationDefault = ... # type: QAbstract3DGraph.OptimizationHint
        OptimizationStatic = ... # type: QAbstract3DGraph.OptimizationHint

    class ElementType(enum.Enum):
        ElementNone = ... # type: QAbstract3DGraph.ElementType
        ElementSeries = ... # type: QAbstract3DGraph.ElementType
        ElementAxisXLabel = ... # type: QAbstract3DGraph.ElementType
        ElementAxisYLabel = ... # type: QAbstract3DGraph.ElementType
        ElementAxisZLabel = ... # type: QAbstract3DGraph.ElementType
        ElementCustomItem = ... # type: QAbstract3DGraph.ElementType

    class ShadowQuality(enum.Enum):
        ShadowQualityNone = ... # type: QAbstract3DGraph.ShadowQuality
        ShadowQualityLow = ... # type: QAbstract3DGraph.ShadowQuality
        ShadowQualityMedium = ... # type: QAbstract3DGraph.ShadowQuality
        ShadowQualityHigh = ... # type: QAbstract3DGraph.ShadowQuality
        ShadowQualitySoftLow = ... # type: QAbstract3DGraph.ShadowQuality
        ShadowQualitySoftMedium = ... # type: QAbstract3DGraph.ShadowQuality
        ShadowQualitySoftHigh = ... # type: QAbstract3DGraph.ShadowQuality

    class SelectionFlag(enum.Flag):
        SelectionNone = ... # type: QAbstract3DGraph.SelectionFlag
        SelectionItem = ... # type: QAbstract3DGraph.SelectionFlag
        SelectionRow = ... # type: QAbstract3DGraph.SelectionFlag
        SelectionItemAndRow = ... # type: QAbstract3DGraph.SelectionFlag
        SelectionColumn = ... # type: QAbstract3DGraph.SelectionFlag
        SelectionItemAndColumn = ... # type: QAbstract3DGraph.SelectionFlag
        SelectionRowAndColumn = ... # type: QAbstract3DGraph.SelectionFlag
        SelectionItemRowAndColumn = ... # type: QAbstract3DGraph.SelectionFlag
        SelectionSlice = ... # type: QAbstract3DGraph.SelectionFlag
        SelectionMultiSeries = ... # type: QAbstract3DGraph.SelectionFlag

    def hasSeries(self, series: 'QAbstract3DSeries|None') -> bool: ...
    def hasContext(self) -> bool: ...
    marginChanged: typing.ClassVar[QtCore.pyqtSignal]
    queriedGraphPositionChanged: typing.ClassVar[QtCore.pyqtSignal]
    localeChanged: typing.ClassVar[QtCore.pyqtSignal]
    reflectivityChanged: typing.ClassVar[QtCore.pyqtSignal]
    reflectionChanged: typing.ClassVar[QtCore.pyqtSignal]
    horizontalAspectRatioChanged: typing.ClassVar[QtCore.pyqtSignal]
    radialLabelOffsetChanged: typing.ClassVar[QtCore.pyqtSignal]
    polarChanged: typing.ClassVar[QtCore.pyqtSignal]
    def margin(self) -> float: ...
    def setMargin(self, margin: float) -> None: ...
    def queriedGraphPosition(self) -> QtGui.QVector3D: ...
    def locale(self) -> QtCore.QLocale: ...
    def setLocale(self, locale: QtCore.QLocale) -> None: ...
    def reflectivity(self) -> float: ...
    def setReflectivity(self, reflectivity: float) -> None: ...
    def isReflection(self) -> bool: ...
    def setReflection(self, enable: bool) -> None: ...
    def horizontalAspectRatio(self) -> float: ...
    def setHorizontalAspectRatio(self, ratio: float) -> None: ...
    def radialLabelOffset(self) -> float: ...
    def setRadialLabelOffset(self, offset: float) -> None: ...
    def isPolar(self) -> bool: ...
    def setPolar(self, enable: bool) -> None: ...
    def customItems(self) -> list['QCustom3DItem']: ...
    optimizationHintsChanged: typing.ClassVar[QtCore.pyqtSignal]
    aspectRatioChanged: typing.ClassVar[QtCore.pyqtSignal]
    orthoProjectionChanged: typing.ClassVar[QtCore.pyqtSignal]
    currentFpsChanged: typing.ClassVar[QtCore.pyqtSignal]
    measureFpsChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedElementChanged: typing.ClassVar[QtCore.pyqtSignal]
    def optimizationHints(self) -> 'QAbstract3DGraph.OptimizationHint': ...
    def setOptimizationHints(self, hints: 'QAbstract3DGraph.OptimizationHint') -> None: ...
    def aspectRatio(self) -> float: ...
    def setAspectRatio(self, ratio: float) -> None: ...
    def selectedElement(self) -> 'QAbstract3DGraph.ElementType': ...
    def isOrthoProjection(self) -> bool: ...
    def setOrthoProjection(self, enable: bool) -> None: ...
    def currentFps(self) -> float: ...
    def measureFps(self) -> bool: ...
    def setMeasureFps(self, enable: bool) -> None: ...
    def renderToImage(self, msaaSamples: int = ..., imageSize: QtCore.QSize = ...) -> QtGui.QImage: ...
    def selectedCustomItem(self) -> 'QCustom3DItem|None': ...
    def selectedCustomItemIndex(self) -> int: ...
    def selectedAxis(self) -> 'QAbstract3DAxis|None': ...
    def selectedLabelIndex(self) -> int: ...
    def releaseCustomItem(self, item: 'QCustom3DItem|None') -> None: ...
    def removeCustomItemAt(self, position: QtGui.QVector3D) -> None: ...
    def removeCustomItem(self, item: 'QCustom3DItem|None') -> None: ...
    def removeCustomItems(self) -> None: ...
    def addCustomItem(self, item: 'QCustom3DItem|None') -> int: ...
    def wheelEvent(self, event: QtGui.QWheelEvent|None) -> None: ...
    def mouseMoveEvent(self, event: QtGui.QMouseEvent|None) -> None: ...
    def mouseReleaseEvent(self, event: QtGui.QMouseEvent|None) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent|None) -> None: ...
    def touchEvent(self, event: QtGui.QTouchEvent|None) -> None: ...
    def mouseDoubleClickEvent(self, event: QtGui.QMouseEvent|None) -> None: ...
    def exposeEvent(self, event: QtGui.QExposeEvent|None) -> None: ...
    def resizeEvent(self, event: QtGui.QResizeEvent|None) -> None: ...
    def event(self, event: QtCore.QEvent|None) -> bool: ...
    shadowQualityChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectionModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    activeThemeChanged: typing.ClassVar[QtCore.pyqtSignal]
    activeInputHandlerChanged: typing.ClassVar[QtCore.pyqtSignal]
    def shadowsSupported(self) -> bool: ...
    def activeInputHandler(self) -> 'QAbstract3DInputHandler|None': ...
    def clearSelection(self) -> None: ...
    def scene(self) -> 'Q3DScene|None': ...
    def shadowQuality(self) -> 'QAbstract3DGraph.ShadowQuality': ...
    def setShadowQuality(self, quality: 'QAbstract3DGraph.ShadowQuality') -> None: ...
    def selectionMode(self) -> 'QAbstract3DGraph.SelectionFlag': ...
    def setSelectionMode(self, mode: 'QAbstract3DGraph.SelectionFlag') -> None: ...
    def themes(self) -> list['Q3DTheme']: ...
    def activeTheme(self) -> 'Q3DTheme|None': ...
    def setActiveTheme(self, theme: 'Q3DTheme|None') -> None: ...
    def releaseTheme(self, theme: 'Q3DTheme|None') -> None: ...
    def addTheme(self, theme: 'Q3DTheme|None') -> None: ...
    def inputHandlers(self) -> list['QAbstract3DInputHandler']: ...
    def setActiveInputHandler(self, inputHandler: 'QAbstract3DInputHandler|None') -> None: ...
    def releaseInputHandler(self, inputHandler: 'QAbstract3DInputHandler|None') -> None: ...
    def addInputHandler(self, inputHandler: 'QAbstract3DInputHandler|None') -> None: ...


class Q3DBars(QAbstract3DGraph):

    def __init__(self, format: QtGui.QSurfaceFormat|None = ..., parent: QtGui.QWindow|None = ...) -> None: ...

    barSeriesMarginChanged: typing.ClassVar[QtCore.pyqtSignal]
    def barSeriesMargin(self) -> QtCore.QSizeF: ...
    def setBarSeriesMargin(self, margin: QtCore.QSizeF) -> None: ...
    floorLevelChanged: typing.ClassVar[QtCore.pyqtSignal]
    def floorLevel(self) -> float: ...
    def setFloorLevel(self, level: float) -> None: ...
    selectedSeriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    primarySeriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    valueAxisChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnAxisChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowAxisChanged: typing.ClassVar[QtCore.pyqtSignal]
    barSpacingRelativeChanged: typing.ClassVar[QtCore.pyqtSignal]
    barSpacingChanged: typing.ClassVar[QtCore.pyqtSignal]
    barThicknessChanged: typing.ClassVar[QtCore.pyqtSignal]
    multiSeriesUniformChanged: typing.ClassVar[QtCore.pyqtSignal]
    def selectedSeries(self) -> 'QBar3DSeries|None': ...
    def axes(self) -> list['QAbstract3DAxis']: ...
    def releaseAxis(self, axis: 'QAbstract3DAxis|None') -> None: ...
    def addAxis(self, axis: 'QAbstract3DAxis|None') -> None: ...
    def valueAxis(self) -> 'QValue3DAxis|None': ...
    def setValueAxis(self, axis: 'QValue3DAxis|None') -> None: ...
    def columnAxis(self) -> 'QCategory3DAxis|None': ...
    def setColumnAxis(self, axis: 'QCategory3DAxis|None') -> None: ...
    def rowAxis(self) -> 'QCategory3DAxis|None': ...
    def setRowAxis(self, axis: 'QCategory3DAxis|None') -> None: ...
    def isBarSpacingRelative(self) -> bool: ...
    def setBarSpacingRelative(self, relative: bool) -> None: ...
    def barSpacing(self) -> QtCore.QSizeF: ...
    def setBarSpacing(self, spacing: QtCore.QSizeF) -> None: ...
    def barThickness(self) -> float: ...
    def setBarThickness(self, thicknessRatio: float) -> None: ...
    def isMultiSeriesUniform(self) -> bool: ...
    def setMultiSeriesUniform(self, uniform: bool) -> None: ...
    def seriesList(self) -> list['QBar3DSeries']: ...
    def insertSeries(self, index: int, series: 'QBar3DSeries|None') -> None: ...
    def removeSeries(self, series: 'QBar3DSeries|None') -> None: ...
    def addSeries(self, series: 'QBar3DSeries|None') -> None: ...
    def primarySeries(self) -> 'QBar3DSeries|None': ...
    def setPrimarySeries(self, series: 'QBar3DSeries|None') -> None: ...


class Q3DObject(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def isDirty(self) -> bool: ...
    def setDirty(self, dirty: bool) -> None: ...
    positionChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setPosition(self, position: QtGui.QVector3D) -> None: ...
    def position(self) -> QtGui.QVector3D: ...
    def parentScene(self) -> 'Q3DScene|None': ...
    def copyValuesFrom(self, source: 'Q3DObject') -> None: ...


class Q3DCamera(Q3DObject):

    class CameraPreset(enum.Enum):
        CameraPresetNone = ... # type: Q3DCamera.CameraPreset
        CameraPresetFrontLow = ... # type: Q3DCamera.CameraPreset
        CameraPresetFront = ... # type: Q3DCamera.CameraPreset
        CameraPresetFrontHigh = ... # type: Q3DCamera.CameraPreset
        CameraPresetLeftLow = ... # type: Q3DCamera.CameraPreset
        CameraPresetLeft = ... # type: Q3DCamera.CameraPreset
        CameraPresetLeftHigh = ... # type: Q3DCamera.CameraPreset
        CameraPresetRightLow = ... # type: Q3DCamera.CameraPreset
        CameraPresetRight = ... # type: Q3DCamera.CameraPreset
        CameraPresetRightHigh = ... # type: Q3DCamera.CameraPreset
        CameraPresetBehindLow = ... # type: Q3DCamera.CameraPreset
        CameraPresetBehind = ... # type: Q3DCamera.CameraPreset
        CameraPresetBehindHigh = ... # type: Q3DCamera.CameraPreset
        CameraPresetIsometricLeft = ... # type: Q3DCamera.CameraPreset
        CameraPresetIsometricLeftHigh = ... # type: Q3DCamera.CameraPreset
        CameraPresetIsometricRight = ... # type: Q3DCamera.CameraPreset
        CameraPresetIsometricRightHigh = ... # type: Q3DCamera.CameraPreset
        CameraPresetDirectlyAbove = ... # type: Q3DCamera.CameraPreset
        CameraPresetDirectlyAboveCW45 = ... # type: Q3DCamera.CameraPreset
        CameraPresetDirectlyAboveCCW45 = ... # type: Q3DCamera.CameraPreset
        CameraPresetFrontBelow = ... # type: Q3DCamera.CameraPreset
        CameraPresetLeftBelow = ... # type: Q3DCamera.CameraPreset
        CameraPresetRightBelow = ... # type: Q3DCamera.CameraPreset
        CameraPresetBehindBelow = ... # type: Q3DCamera.CameraPreset
        CameraPresetDirectlyBelow = ... # type: Q3DCamera.CameraPreset

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    targetChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxZoomLevelChanged: typing.ClassVar[QtCore.pyqtSignal]
    minZoomLevelChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setTarget(self, target: QtGui.QVector3D) -> None: ...
    def target(self) -> QtGui.QVector3D: ...
    def setMaxZoomLevel(self, zoomLevel: float) -> None: ...
    def maxZoomLevel(self) -> float: ...
    def setMinZoomLevel(self, zoomLevel: float) -> None: ...
    def minZoomLevel(self) -> float: ...
    wrapYRotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    wrapXRotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    cameraPresetChanged: typing.ClassVar[QtCore.pyqtSignal]
    zoomLevelChanged: typing.ClassVar[QtCore.pyqtSignal]
    yRotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    xRotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setZoomLevel(self, zoomLevel: float) -> None: ...
    def zoomLevel(self) -> float: ...
    def setCameraPosition(self, horizontal: float, vertical: float, zoom: float = ...) -> None: ...
    def setCameraPreset(self, preset: 'Q3DCamera.CameraPreset') -> None: ...
    def cameraPreset(self) -> 'Q3DCamera.CameraPreset': ...
    def copyValuesFrom(self, source: Q3DObject) -> None: ...
    def setWrapYRotation(self, isEnabled: bool) -> None: ...
    def wrapYRotation(self) -> bool: ...
    def setWrapXRotation(self, isEnabled: bool) -> None: ...
    def wrapXRotation(self) -> bool: ...
    def setYRotation(self, rotation: float) -> None: ...
    def yRotation(self) -> float: ...
    def setXRotation(self, rotation: float) -> None: ...
    def xRotation(self) -> float: ...


class QAbstract3DInputHandler(QtCore.QObject):

    class InputView(enum.Enum):
        InputViewNone = ... # type: QAbstract3DInputHandler.InputView
        InputViewOnPrimary = ... # type: QAbstract3DInputHandler.InputView
        InputViewOnSecondary = ... # type: QAbstract3DInputHandler.InputView

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def previousInputPos(self) -> QtCore.QPoint: ...
    def setPreviousInputPos(self, position: QtCore.QPoint) -> None: ...
    def prevDistance(self) -> int: ...
    def setPrevDistance(self, distance: int) -> None: ...
    sceneChanged: typing.ClassVar[QtCore.pyqtSignal]
    inputViewChanged: typing.ClassVar[QtCore.pyqtSignal]
    positionChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setScene(self, scene: 'Q3DScene|None') -> None: ...
    def scene(self) -> 'Q3DScene|None': ...
    def setInputPosition(self, position: QtCore.QPoint) -> None: ...
    def inputPosition(self) -> QtCore.QPoint: ...
    def setInputView(self, inputView: 'QAbstract3DInputHandler.InputView') -> None: ...
    def inputView(self) -> 'QAbstract3DInputHandler.InputView': ...
    def wheelEvent(self, event: QtGui.QWheelEvent|None) -> None: ...
    def mouseMoveEvent(self, event: QtGui.QMouseEvent|None, mousePos: QtCore.QPoint) -> None: ...
    def mouseReleaseEvent(self, event: QtGui.QMouseEvent|None, mousePos: QtCore.QPoint) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent|None, mousePos: QtCore.QPoint) -> None: ...
    def touchEvent(self, event: QtGui.QTouchEvent|None) -> None: ...
    def mouseDoubleClickEvent(self, event: QtGui.QMouseEvent|None) -> None: ...


class Q3DInputHandler(QAbstract3DInputHandler):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    zoomAtTargetEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectionEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    zoomEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    def isZoomAtTargetEnabled(self) -> bool: ...
    def setZoomAtTargetEnabled(self, enable: bool) -> None: ...
    def isSelectionEnabled(self) -> bool: ...
    def setSelectionEnabled(self, enable: bool) -> None: ...
    def isZoomEnabled(self) -> bool: ...
    def setZoomEnabled(self, enable: bool) -> None: ...
    def isRotationEnabled(self) -> bool: ...
    def setRotationEnabled(self, enable: bool) -> None: ...
    def wheelEvent(self, event: QtGui.QWheelEvent|None) -> None: ...
    def mouseMoveEvent(self, event: QtGui.QMouseEvent|None, mousePos: QtCore.QPoint) -> None: ...
    def mouseReleaseEvent(self, event: QtGui.QMouseEvent|None, mousePos: QtCore.QPoint) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent|None, mousePos: QtCore.QPoint) -> None: ...


class Q3DLight(Q3DObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    autoPositionChanged: typing.ClassVar[QtCore.pyqtSignal]
    def isAutoPosition(self) -> bool: ...
    def setAutoPosition(self, enabled: bool) -> None: ...


class Q3DScatter(QAbstract3DGraph):

    def __init__(self, format: QtGui.QSurfaceFormat|None = ..., parent: QtGui.QWindow|None = ...) -> None: ...

    selectedSeriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisZChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisYChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisXChanged: typing.ClassVar[QtCore.pyqtSignal]
    def selectedSeries(self) -> 'QScatter3DSeries|None': ...
    def axes(self) -> list['QValue3DAxis']: ...
    def releaseAxis(self, axis: 'QValue3DAxis|None') -> None: ...
    def addAxis(self, axis: 'QValue3DAxis|None') -> None: ...
    def axisZ(self) -> 'QValue3DAxis|None': ...
    def setAxisZ(self, axis: 'QValue3DAxis|None') -> None: ...
    def axisY(self) -> 'QValue3DAxis|None': ...
    def setAxisY(self, axis: 'QValue3DAxis|None') -> None: ...
    def axisX(self) -> 'QValue3DAxis|None': ...
    def setAxisX(self, axis: 'QValue3DAxis|None') -> None: ...
    def seriesList(self) -> list['QScatter3DSeries']: ...
    def removeSeries(self, series: 'QScatter3DSeries|None') -> None: ...
    def addSeries(self, series: 'QScatter3DSeries|None') -> None: ...


class Q3DScene(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    graphPositionQueryChanged: typing.ClassVar[QtCore.pyqtSignal]
    def graphPositionQuery(self) -> QtCore.QPoint: ...
    def setGraphPositionQuery(self, point: QtCore.QPoint) -> None: ...
    selectionQueryPositionChanged: typing.ClassVar[QtCore.pyqtSignal]
    devicePixelRatioChanged: typing.ClassVar[QtCore.pyqtSignal]
    activeLightChanged: typing.ClassVar[QtCore.pyqtSignal]
    activeCameraChanged: typing.ClassVar[QtCore.pyqtSignal]
    slicingActiveChanged: typing.ClassVar[QtCore.pyqtSignal]
    secondarySubviewOnTopChanged: typing.ClassVar[QtCore.pyqtSignal]
    secondarySubViewportChanged: typing.ClassVar[QtCore.pyqtSignal]
    primarySubViewportChanged: typing.ClassVar[QtCore.pyqtSignal]
    viewportChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setDevicePixelRatio(self, pixelRatio: float) -> None: ...
    def devicePixelRatio(self) -> float: ...
    def setActiveLight(self, light: Q3DLight|None) -> None: ...
    def activeLight(self) -> Q3DLight|None: ...
    def setActiveCamera(self, camera: Q3DCamera|None) -> None: ...
    def activeCamera(self) -> Q3DCamera|None: ...
    def isSecondarySubviewOnTop(self) -> bool: ...
    def setSecondarySubviewOnTop(self, isSecondaryOnTop: bool) -> None: ...
    def isSlicingActive(self) -> bool: ...
    def setSlicingActive(self, isSlicing: bool) -> None: ...
    @staticmethod
    def invalidSelectionPoint() -> QtCore.QPoint: ...
    def selectionQueryPosition(self) -> QtCore.QPoint: ...
    def setSelectionQueryPosition(self, point: QtCore.QPoint) -> None: ...
    def isPointInSecondarySubView(self, point: QtCore.QPoint) -> bool: ...
    def setSecondarySubViewport(self, secondarySubViewport: QtCore.QRect) -> None: ...
    def secondarySubViewport(self) -> QtCore.QRect: ...
    def isPointInPrimarySubView(self, point: QtCore.QPoint) -> bool: ...
    def setPrimarySubViewport(self, primarySubViewport: QtCore.QRect) -> None: ...
    def primarySubViewport(self) -> QtCore.QRect: ...
    def viewport(self) -> QtCore.QRect: ...


class Q3DSurface(QAbstract3DGraph):

    def __init__(self, format: QtGui.QSurfaceFormat|None = ..., parent: QtGui.QWindow|None = ...) -> None: ...

    flipHorizontalGridChanged: typing.ClassVar[QtCore.pyqtSignal]
    def flipHorizontalGrid(self) -> bool: ...
    def setFlipHorizontalGrid(self, flip: bool) -> None: ...
    selectedSeriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisZChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisYChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisXChanged: typing.ClassVar[QtCore.pyqtSignal]
    def selectedSeries(self) -> 'QSurface3DSeries|None': ...
    def axes(self) -> list['QValue3DAxis']: ...
    def releaseAxis(self, axis: 'QValue3DAxis|None') -> None: ...
    def addAxis(self, axis: 'QValue3DAxis|None') -> None: ...
    def axisZ(self) -> 'QValue3DAxis|None': ...
    def setAxisZ(self, axis: 'QValue3DAxis|None') -> None: ...
    def axisY(self) -> 'QValue3DAxis|None': ...
    def setAxisY(self, axis: 'QValue3DAxis|None') -> None: ...
    def axisX(self) -> 'QValue3DAxis|None': ...
    def setAxisX(self, axis: 'QValue3DAxis|None') -> None: ...
    def seriesList(self) -> list['QSurface3DSeries']: ...
    def removeSeries(self, series: 'QSurface3DSeries|None') -> None: ...
    def addSeries(self, series: 'QSurface3DSeries|None') -> None: ...


class Q3DTheme(QtCore.QObject):

    class Theme(enum.Enum):
        ThemeQt = ... # type: Q3DTheme.Theme
        ThemePrimaryColors = ... # type: Q3DTheme.Theme
        ThemeDigia = ... # type: Q3DTheme.Theme
        ThemeStoneMoss = ... # type: Q3DTheme.Theme
        ThemeArmyBlue = ... # type: Q3DTheme.Theme
        ThemeRetro = ... # type: Q3DTheme.Theme
        ThemeEbony = ... # type: Q3DTheme.Theme
        ThemeIsabelle = ... # type: Q3DTheme.Theme
        ThemeUserDefined = ... # type: Q3DTheme.Theme

    class ColorStyle(enum.Enum):
        ColorStyleUniform = ... # type: Q3DTheme.ColorStyle
        ColorStyleObjectGradient = ... # type: Q3DTheme.ColorStyle
        ColorStyleRangeGradient = ... # type: Q3DTheme.ColorStyle

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, themeType: 'Q3DTheme.Theme', parent: QtCore.QObject|None = ...) -> None: ...

    colorStyleChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelBackgroundEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    gridEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    backgroundEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    fontChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelBorderEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    highlightLightStrengthChanged: typing.ClassVar[QtCore.pyqtSignal]
    ambientLightStrengthChanged: typing.ClassVar[QtCore.pyqtSignal]
    lightStrengthChanged: typing.ClassVar[QtCore.pyqtSignal]
    multiHighlightGradientChanged: typing.ClassVar[QtCore.pyqtSignal]
    singleHighlightGradientChanged: typing.ClassVar[QtCore.pyqtSignal]
    baseGradientsChanged: typing.ClassVar[QtCore.pyqtSignal]
    lightColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    multiHighlightColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    singleHighlightColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    gridLineColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelBackgroundColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelTextColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    windowColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    backgroundColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    baseColorsChanged: typing.ClassVar[QtCore.pyqtSignal]
    typeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def colorStyle(self) -> 'Q3DTheme.ColorStyle': ...
    def setColorStyle(self, style: 'Q3DTheme.ColorStyle') -> None: ...
    def isLabelBackgroundEnabled(self) -> bool: ...
    def setLabelBackgroundEnabled(self, enabled: bool) -> None: ...
    def isGridEnabled(self) -> bool: ...
    def setGridEnabled(self, enabled: bool) -> None: ...
    def isBackgroundEnabled(self) -> bool: ...
    def setBackgroundEnabled(self, enabled: bool) -> None: ...
    def font(self) -> QtGui.QFont: ...
    def setFont(self, font: QtGui.QFont) -> None: ...
    def isLabelBorderEnabled(self) -> bool: ...
    def setLabelBorderEnabled(self, enabled: bool) -> None: ...
    def highlightLightStrength(self) -> float: ...
    def setHighlightLightStrength(self, strength: float) -> None: ...
    def ambientLightStrength(self) -> float: ...
    def setAmbientLightStrength(self, strength: float) -> None: ...
    def lightStrength(self) -> float: ...
    def setLightStrength(self, strength: float) -> None: ...
    def multiHighlightGradient(self) -> QtGui.QLinearGradient: ...
    def setMultiHighlightGradient(self, gradient: QtGui.QLinearGradient) -> None: ...
    def singleHighlightGradient(self) -> QtGui.QLinearGradient: ...
    def setSingleHighlightGradient(self, gradient: QtGui.QLinearGradient) -> None: ...
    def baseGradients(self) -> list[QtGui.QLinearGradient]: ...
    def setBaseGradients(self, gradients: collections.abc.Iterable[QtGui.QLinearGradient]) -> None: ...
    def lightColor(self) -> QtGui.QColor: ...
    def setLightColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def multiHighlightColor(self) -> QtGui.QColor: ...
    def setMultiHighlightColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def singleHighlightColor(self) -> QtGui.QColor: ...
    def setSingleHighlightColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def gridLineColor(self) -> QtGui.QColor: ...
    def setGridLineColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def labelBackgroundColor(self) -> QtGui.QColor: ...
    def setLabelBackgroundColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def labelTextColor(self) -> QtGui.QColor: ...
    def setLabelTextColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def windowColor(self) -> QtGui.QColor: ...
    def setWindowColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def setBackgroundColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def baseColors(self) -> list[QtGui.QColor]: ...
    def setBaseColors(self, colors: collections.abc.Iterable[QtGui.QColor|QtCore.Qt.GlobalColor|int]) -> None: ...
    def type(self) -> 'Q3DTheme.Theme': ...
    def setType(self, themeType: 'Q3DTheme.Theme') -> None: ...


class QAbstract3DAxis(QtCore.QObject):

    class AxisType(enum.Enum):
        AxisTypeNone = ... # type: QAbstract3DAxis.AxisType
        AxisTypeCategory = ... # type: QAbstract3DAxis.AxisType
        AxisTypeValue = ... # type: QAbstract3DAxis.AxisType

    class AxisOrientation(enum.Enum):
        AxisOrientationNone = ... # type: QAbstract3DAxis.AxisOrientation
        AxisOrientationX = ... # type: QAbstract3DAxis.AxisOrientation
        AxisOrientationY = ... # type: QAbstract3DAxis.AxisOrientation
        AxisOrientationZ = ... # type: QAbstract3DAxis.AxisOrientation

    titleFixedChanged: typing.ClassVar[QtCore.pyqtSignal]
    titleVisibilityChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelAutoRotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    def isTitleFixed(self) -> bool: ...
    def setTitleFixed(self, fixed: bool) -> None: ...
    def isTitleVisible(self) -> bool: ...
    def setTitleVisible(self, visible: bool) -> None: ...
    def labelAutoRotation(self) -> float: ...
    def setLabelAutoRotation(self, angle: float) -> None: ...
    autoAdjustRangeChanged: typing.ClassVar[QtCore.pyqtSignal]
    rangeChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxChanged: typing.ClassVar[QtCore.pyqtSignal]
    minChanged: typing.ClassVar[QtCore.pyqtSignal]
    orientationChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsChanged: typing.ClassVar[QtCore.pyqtSignal]
    titleChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setTitle(self, title: str|None) -> None: ...
    def setRange(self, min: float, max: float) -> None: ...
    def isAutoAdjustRange(self) -> bool: ...
    def setAutoAdjustRange(self, autoAdjust: bool) -> None: ...
    def max(self) -> float: ...
    def setMax(self, max: float) -> None: ...
    def min(self) -> float: ...
    def setMin(self, min: float) -> None: ...
    def type(self) -> 'QAbstract3DAxis.AxisType': ...
    def orientation(self) -> 'QAbstract3DAxis.AxisOrientation': ...
    def labels(self) -> list[str]: ...
    def setLabels(self, labels: collections.abc.Iterable[str|None]) -> None: ...
    def title(self) -> str: ...


class QAbstract3DSeries(QtCore.QObject):

    class Mesh(enum.Enum):
        MeshUserDefined = ... # type: QAbstract3DSeries.Mesh
        MeshBar = ... # type: QAbstract3DSeries.Mesh
        MeshCube = ... # type: QAbstract3DSeries.Mesh
        MeshPyramid = ... # type: QAbstract3DSeries.Mesh
        MeshCone = ... # type: QAbstract3DSeries.Mesh
        MeshCylinder = ... # type: QAbstract3DSeries.Mesh
        MeshBevelBar = ... # type: QAbstract3DSeries.Mesh
        MeshBevelCube = ... # type: QAbstract3DSeries.Mesh
        MeshSphere = ... # type: QAbstract3DSeries.Mesh
        MeshMinimal = ... # type: QAbstract3DSeries.Mesh
        MeshArrow = ... # type: QAbstract3DSeries.Mesh
        MeshPoint = ... # type: QAbstract3DSeries.Mesh

    class SeriesType(enum.Enum):
        SeriesTypeNone = ... # type: QAbstract3DSeries.SeriesType
        SeriesTypeBar = ... # type: QAbstract3DSeries.SeriesType
        SeriesTypeScatter = ... # type: QAbstract3DSeries.SeriesType
        SeriesTypeSurface = ... # type: QAbstract3DSeries.SeriesType

    itemLabelVisibilityChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemLabelChanged: typing.ClassVar[QtCore.pyqtSignal]
    def isItemLabelVisible(self) -> bool: ...
    def setItemLabelVisible(self, visible: bool) -> None: ...
    def itemLabel(self) -> str: ...
    nameChanged: typing.ClassVar[QtCore.pyqtSignal]
    multiHighlightGradientChanged: typing.ClassVar[QtCore.pyqtSignal]
    multiHighlightColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    singleHighlightGradientChanged: typing.ClassVar[QtCore.pyqtSignal]
    singleHighlightColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    baseGradientChanged: typing.ClassVar[QtCore.pyqtSignal]
    baseColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    colorStyleChanged: typing.ClassVar[QtCore.pyqtSignal]
    userDefinedMeshChanged: typing.ClassVar[QtCore.pyqtSignal]
    meshRotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    meshSmoothChanged: typing.ClassVar[QtCore.pyqtSignal]
    meshChanged: typing.ClassVar[QtCore.pyqtSignal]
    visibilityChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemLabelFormatChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setMeshAxisAndAngle(self, axis: QtGui.QVector3D, angle: float) -> None: ...
    def name(self) -> str: ...
    def setName(self, name: str|None) -> None: ...
    def multiHighlightGradient(self) -> QtGui.QLinearGradient: ...
    def setMultiHighlightGradient(self, gradient: QtGui.QLinearGradient) -> None: ...
    def multiHighlightColor(self) -> QtGui.QColor: ...
    def setMultiHighlightColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def singleHighlightGradient(self) -> QtGui.QLinearGradient: ...
    def setSingleHighlightGradient(self, gradient: QtGui.QLinearGradient) -> None: ...
    def singleHighlightColor(self) -> QtGui.QColor: ...
    def setSingleHighlightColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def baseGradient(self) -> QtGui.QLinearGradient: ...
    def setBaseGradient(self, gradient: QtGui.QLinearGradient) -> None: ...
    def baseColor(self) -> QtGui.QColor: ...
    def setBaseColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def colorStyle(self) -> Q3DTheme.ColorStyle: ...
    def setColorStyle(self, style: Q3DTheme.ColorStyle) -> None: ...
    def userDefinedMesh(self) -> str: ...
    def setUserDefinedMesh(self, fileName: str|None) -> None: ...
    def meshRotation(self) -> QtGui.QQuaternion: ...
    def setMeshRotation(self, rotation: QtGui.QQuaternion) -> None: ...
    def isMeshSmooth(self) -> bool: ...
    def setMeshSmooth(self, enable: bool) -> None: ...
    def mesh(self) -> 'QAbstract3DSeries.Mesh': ...
    def setMesh(self, mesh: 'QAbstract3DSeries.Mesh') -> None: ...
    def isVisible(self) -> bool: ...
    def setVisible(self, visible: bool) -> None: ...
    def itemLabelFormat(self) -> str: ...
    def setItemLabelFormat(self, format: str|None) -> None: ...
    def type(self) -> 'QAbstract3DSeries.SeriesType': ...


class QAbstractDataProxy(QtCore.QObject):

    class DataType(enum.Enum):
        DataTypeNone = ... # type: QAbstractDataProxy.DataType
        DataTypeBar = ... # type: QAbstractDataProxy.DataType
        DataTypeScatter = ... # type: QAbstractDataProxy.DataType
        DataTypeSurface = ... # type: QAbstractDataProxy.DataType

    def type(self) -> 'QAbstractDataProxy.DataType': ...


class QBar3DSeries(QAbstract3DSeries):

    @typing.overload
    def __init__(self, dataProxy: 'QBarDataProxy|None', parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    rowColorsChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setRowColors(self, colors: collections.abc.Iterable[QtGui.QColor|QtCore.Qt.GlobalColor|int]) -> None: ...
    def rowColors(self) -> list[QtGui.QColor]: ...
    meshAngleChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedBarChanged: typing.ClassVar[QtCore.pyqtSignal]
    dataProxyChanged: typing.ClassVar[QtCore.pyqtSignal]
    def meshAngle(self) -> float: ...
    def setMeshAngle(self, angle: float) -> None: ...
    @staticmethod
    def invalidSelectionPosition() -> QtCore.QPoint: ...
    def selectedBar(self) -> QtCore.QPoint: ...
    def setSelectedBar(self, position: QtCore.QPoint) -> None: ...
    def dataProxy(self) -> 'QBarDataProxy|None': ...
    def setDataProxy(self, proxy: 'QBarDataProxy|None') -> None: ...


class QBarDataItem(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, value: float) -> None: ...
    @typing.overload
    def __init__(self, value: float, angle: float) -> None: ...
    @typing.overload
    def __init__(self, other: 'QBarDataItem') -> None: ...

    def rotation(self) -> float: ...
    def setRotation(self, angle: float) -> None: ...
    def value(self) -> float: ...
    def setValue(self, value: float) -> None: ...


class QBarDataProxy(QAbstractDataProxy):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    seriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnLabelsChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowLabelsChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowsInserted: typing.ClassVar[QtCore.pyqtSignal]
    rowsRemoved: typing.ClassVar[QtCore.pyqtSignal]
    rowsChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowsAdded: typing.ClassVar[QtCore.pyqtSignal]
    arrayReset: typing.ClassVar[QtCore.pyqtSignal]
    def series(self) -> QBar3DSeries|None: ...
    def removeRows(self, rowIndex: int, removeCount: int, removeLabels: bool = ...) -> None: ...
    @typing.overload
    def insertRows(self, rowIndex: int, rows: collections.abc.Iterable[collections.abc.Iterable[QBarDataItem]]) -> None: ...
    @typing.overload
    def insertRows(self, rowIndex: int, rows: collections.abc.Iterable[collections.abc.Iterable[QBarDataItem]], labels: collections.abc.Iterable[str|None]) -> None: ...
    @typing.overload
    def insertRow(self, rowIndex: int, row: collections.abc.Iterable[QBarDataItem]) -> None: ...
    @typing.overload
    def insertRow(self, rowIndex: int, row: collections.abc.Iterable[QBarDataItem], label: str|None) -> None: ...
    @typing.overload
    def addRows(self, rows: collections.abc.Iterable[collections.abc.Iterable[QBarDataItem]]) -> int: ...
    @typing.overload
    def addRows(self, rows: collections.abc.Iterable[collections.abc.Iterable[QBarDataItem]], labels: collections.abc.Iterable[str|None]) -> int: ...
    @typing.overload
    def addRow(self, row: collections.abc.Iterable[QBarDataItem]) -> int: ...
    @typing.overload
    def addRow(self, row: collections.abc.Iterable[QBarDataItem], label: str|None) -> int: ...
    @typing.overload
    def setItem(self, rowIndex: int, columnIndex: int, item: QBarDataItem) -> None: ...
    @typing.overload
    def setItem(self, position: QtCore.QPoint, item: QBarDataItem) -> None: ...
    @typing.overload
    def setRows(self, rowIndex: int, rows: collections.abc.Iterable[collections.abc.Iterable[QBarDataItem]]) -> None: ...
    @typing.overload
    def setRows(self, rowIndex: int, rows: collections.abc.Iterable[collections.abc.Iterable[QBarDataItem]], labels: collections.abc.Iterable[str|None]) -> None: ...
    @typing.overload
    def setRow(self, rowIndex: int, row: collections.abc.Iterable[QBarDataItem]) -> None: ...
    @typing.overload
    def setRow(self, rowIndex: int, row: collections.abc.Iterable[QBarDataItem], label: str|None) -> None: ...
    @typing.overload
    def resetArray(self) -> None: ...
    @typing.overload
    def resetArray(self, newArray: collections.abc.Iterable[collections.abc.Iterable[QBarDataItem]]) -> None: ...
    @typing.overload
    def resetArray(self, newArray: collections.abc.Iterable[collections.abc.Iterable[QBarDataItem]], rowLabels: collections.abc.Iterable[str|None], columnLabels: collections.abc.Iterable[str|None]) -> None: ...
    @typing.overload
    def itemAt(self, rowIndex: int, columnIndex: int) -> QBarDataItem|None: ...
    @typing.overload
    def itemAt(self, position: QtCore.QPoint) -> QBarDataItem|None: ...
    def rowAt(self, rowIndex: int) -> list[QBarDataItem]: ...
    def array(self) -> list[list[QBarDataItem]]: ...
    def setColumnLabels(self, labels: collections.abc.Iterable[str|None]) -> None: ...
    def columnLabels(self) -> list[str]: ...
    def setRowLabels(self, labels: collections.abc.Iterable[str|None]) -> None: ...
    def rowLabels(self) -> list[str]: ...
    def rowCount(self) -> int: ...


class QCategory3DAxis(QAbstract3DAxis):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    labelsChanged: typing.ClassVar[QtCore.pyqtSignal]
    def labels(self) -> list[str]: ...
    def setLabels(self, labels: collections.abc.Iterable[str|None]) -> None: ...


class QCustom3DItem(QtCore.QObject):

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, meshFile: str|None, position: QtGui.QVector3D, scaling: QtGui.QVector3D, rotation: QtGui.QQuaternion, texture: QtGui.QImage, parent: QtCore.QObject|None = ...) -> None: ...

    scalingAbsoluteChanged: typing.ClassVar[QtCore.pyqtSignal]
    def isScalingAbsolute(self) -> bool: ...
    def setScalingAbsolute(self, scalingAbsolute: bool) -> None: ...
    shadowCastingChanged: typing.ClassVar[QtCore.pyqtSignal]
    visibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    scalingChanged: typing.ClassVar[QtCore.pyqtSignal]
    positionAbsoluteChanged: typing.ClassVar[QtCore.pyqtSignal]
    positionChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureFileChanged: typing.ClassVar[QtCore.pyqtSignal]
    meshFileChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setTextureImage(self, textureImage: QtGui.QImage) -> None: ...
    def setRotationAxisAndAngle(self, axis: QtGui.QVector3D, angle: float) -> None: ...
    def isShadowCasting(self) -> bool: ...
    def setShadowCasting(self, enabled: bool) -> None: ...
    def isVisible(self) -> bool: ...
    def setVisible(self, visible: bool) -> None: ...
    def rotation(self) -> QtGui.QQuaternion: ...
    def setRotation(self, rotation: QtGui.QQuaternion) -> None: ...
    def scaling(self) -> QtGui.QVector3D: ...
    def setScaling(self, scaling: QtGui.QVector3D) -> None: ...
    def isPositionAbsolute(self) -> bool: ...
    def setPositionAbsolute(self, positionAbsolute: bool) -> None: ...
    def position(self) -> QtGui.QVector3D: ...
    def setPosition(self, position: QtGui.QVector3D) -> None: ...
    def textureFile(self) -> str: ...
    def setTextureFile(self, textureFile: str|None) -> None: ...
    def meshFile(self) -> str: ...
    def setMeshFile(self, meshFile: str|None) -> None: ...


class QCustom3DLabel(QCustom3DItem):

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str|None, font: QtGui.QFont, position: QtGui.QVector3D, scaling: QtGui.QVector3D, rotation: QtGui.QQuaternion, parent: QtCore.QObject|None = ...) -> None: ...

    facingCameraChanged: typing.ClassVar[QtCore.pyqtSignal]
    backgroundEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    borderEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    backgroundColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    textColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    fontChanged: typing.ClassVar[QtCore.pyqtSignal]
    textChanged: typing.ClassVar[QtCore.pyqtSignal]
    def isFacingCamera(self) -> bool: ...
    def setFacingCamera(self, enabled: bool) -> None: ...
    def isBackgroundEnabled(self) -> bool: ...
    def setBackgroundEnabled(self, enabled: bool) -> None: ...
    def isBorderEnabled(self) -> bool: ...
    def setBorderEnabled(self, enabled: bool) -> None: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def setBackgroundColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def textColor(self) -> QtGui.QColor: ...
    def setTextColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def font(self) -> QtGui.QFont: ...
    def setFont(self, font: QtGui.QFont) -> None: ...
    def text(self) -> str: ...
    def setText(self, text: str|None) -> None: ...


class QCustom3DVolume(QCustom3DItem):

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, position: QtGui.QVector3D, scaling: QtGui.QVector3D, rotation: QtGui.QQuaternion, textureWidth: int, textureHeight: int, textureDepth: int, textureData: sip.array, textureFormat: QtGui.QImage.Format, colorTable: collections.abc.Iterable[int], parent: QtCore.QObject|None = ...) -> None: ...

    sliceFrameThicknessesChanged: typing.ClassVar[QtCore.pyqtSignal]
    sliceFrameGapsChanged: typing.ClassVar[QtCore.pyqtSignal]
    sliceFrameWidthsChanged: typing.ClassVar[QtCore.pyqtSignal]
    sliceFrameColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    drawSliceFramesChanged: typing.ClassVar[QtCore.pyqtSignal]
    drawSlicesChanged: typing.ClassVar[QtCore.pyqtSignal]
    useHighDefShaderChanged: typing.ClassVar[QtCore.pyqtSignal]
    preserveOpacityChanged: typing.ClassVar[QtCore.pyqtSignal]
    alphaMultiplierChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureFormatChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureDataChanged: typing.ClassVar[QtCore.pyqtSignal]
    colorTableChanged: typing.ClassVar[QtCore.pyqtSignal]
    sliceIndexZChanged: typing.ClassVar[QtCore.pyqtSignal]
    sliceIndexYChanged: typing.ClassVar[QtCore.pyqtSignal]
    sliceIndexXChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureDepthChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureHeightChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureWidthChanged: typing.ClassVar[QtCore.pyqtSignal]
    def renderSlice(self, axis: QtCore.Qt.Axis, index: int) -> QtGui.QImage: ...
    def sliceFrameThicknesses(self) -> QtGui.QVector3D: ...
    def setSliceFrameThicknesses(self, values: QtGui.QVector3D) -> None: ...
    def sliceFrameGaps(self) -> QtGui.QVector3D: ...
    def setSliceFrameGaps(self, values: QtGui.QVector3D) -> None: ...
    def sliceFrameWidths(self) -> QtGui.QVector3D: ...
    def setSliceFrameWidths(self, values: QtGui.QVector3D) -> None: ...
    def sliceFrameColor(self) -> QtGui.QColor: ...
    def setSliceFrameColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def drawSliceFrames(self) -> bool: ...
    def setDrawSliceFrames(self, enable: bool) -> None: ...
    def drawSlices(self) -> bool: ...
    def setDrawSlices(self, enable: bool) -> None: ...
    def useHighDefShader(self) -> bool: ...
    def setUseHighDefShader(self, enable: bool) -> None: ...
    def preserveOpacity(self) -> bool: ...
    def setPreserveOpacity(self, enable: bool) -> None: ...
    def alphaMultiplier(self) -> float: ...
    def setAlphaMultiplier(self, mult: float) -> None: ...
    def textureFormat(self) -> QtGui.QImage.Format: ...
    def setTextureFormat(self, format: QtGui.QImage.Format) -> None: ...
    @typing.overload
    def setSubTextureData(self, axis: QtCore.Qt.Axis, index: int, data: PyQt6.sip.voidptr) -> None: ...
    @typing.overload
    def setSubTextureData(self, axis: QtCore.Qt.Axis, index: int, image: QtGui.QImage) -> None: ...
    def textureData(self) -> sip.array: ...
    def createTextureData(self, images: collections.abc.Iterable[QtGui.QImage]) -> sip.array: ...
    def setTextureData(self, data: sip.array) -> None: ...
    def colorTable(self) -> list[int]: ...
    def setColorTable(self, colors: collections.abc.Iterable[int]) -> None: ...
    def setSliceIndices(self, x: int, y: int, z: int) -> None: ...
    def sliceIndexZ(self) -> int: ...
    def setSliceIndexZ(self, value: int) -> None: ...
    def sliceIndexY(self) -> int: ...
    def setSliceIndexY(self, value: int) -> None: ...
    def sliceIndexX(self) -> int: ...
    def setSliceIndexX(self, value: int) -> None: ...
    def textureDataWidth(self) -> int: ...
    def setTextureDimensions(self, width: int, height: int, depth: int) -> None: ...
    def textureDepth(self) -> int: ...
    def setTextureDepth(self, value: int) -> None: ...
    def textureHeight(self) -> int: ...
    def setTextureHeight(self, value: int) -> None: ...
    def textureWidth(self) -> int: ...
    def setTextureWidth(self, value: int) -> None: ...


class QSurfaceDataProxy(QAbstractDataProxy):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    seriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowsInserted: typing.ClassVar[QtCore.pyqtSignal]
    rowsRemoved: typing.ClassVar[QtCore.pyqtSignal]
    rowsChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowsAdded: typing.ClassVar[QtCore.pyqtSignal]
    arrayReset: typing.ClassVar[QtCore.pyqtSignal]
    @typing.overload
    def itemAt(self, rowIndex: int, columnIndex: int) -> 'QSurfaceDataItem|None': ...
    @typing.overload
    def itemAt(self, position: QtCore.QPoint) -> 'QSurfaceDataItem|None': ...
    def series(self) -> 'QSurface3DSeries|None': ...
    def removeRows(self, rowIndex: int, removeCount: int) -> None: ...
    def insertRows(self, rowIndex: int, rows: collections.abc.Iterable[collections.abc.Iterable['QSurfaceDataItem']]) -> None: ...
    def insertRow(self, rowIndex: int, row: collections.abc.Iterable['QSurfaceDataItem']) -> None: ...
    def addRows(self, rows: collections.abc.Iterable[collections.abc.Iterable['QSurfaceDataItem']]) -> int: ...
    def addRow(self, row: collections.abc.Iterable['QSurfaceDataItem']) -> int: ...
    @typing.overload
    def setItem(self, rowIndex: int, columnIndex: int, item: 'QSurfaceDataItem') -> None: ...
    @typing.overload
    def setItem(self, position: QtCore.QPoint, item: 'QSurfaceDataItem') -> None: ...
    def setRows(self, rowIndex: int, rows: collections.abc.Iterable[collections.abc.Iterable['QSurfaceDataItem']]) -> None: ...
    def setRow(self, rowIndex: int, row: collections.abc.Iterable['QSurfaceDataItem']) -> None: ...
    def resetArray(self, newArray: collections.abc.Iterable[collections.abc.Iterable['QSurfaceDataItem']]) -> None: ...
    def array(self) -> list[list['QSurfaceDataItem']]: ...
    def columnCount(self) -> int: ...
    def rowCount(self) -> int: ...


class QHeightMapSurfaceDataProxy(QSurfaceDataProxy):

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, image: QtGui.QImage, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, filename: str|None, parent: QtCore.QObject|None = ...) -> None: ...

    autoScaleYChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxYValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    minYValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    def autoScaleY(self) -> bool: ...
    def setAutoScaleY(self, enabled: bool) -> None: ...
    def maxYValue(self) -> float: ...
    def setMaxYValue(self, max: float) -> None: ...
    def minYValue(self) -> float: ...
    def setMinYValue(self, min: float) -> None: ...
    maxZValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    minZValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxXValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    minXValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    heightMapFileChanged: typing.ClassVar[QtCore.pyqtSignal]
    heightMapChanged: typing.ClassVar[QtCore.pyqtSignal]
    def maxZValue(self) -> float: ...
    def setMaxZValue(self, max: float) -> None: ...
    def minZValue(self) -> float: ...
    def setMinZValue(self, min: float) -> None: ...
    def maxXValue(self) -> float: ...
    def setMaxXValue(self, max: float) -> None: ...
    def minXValue(self) -> float: ...
    def setMinXValue(self, min: float) -> None: ...
    def setValueRanges(self, minX: float, maxX: float, minZ: float, maxZ: float) -> None: ...
    def heightMapFile(self) -> str: ...
    def setHeightMapFile(self, filename: str|None) -> None: ...
    def heightMap(self) -> QtGui.QImage: ...
    def setHeightMap(self, image: QtGui.QImage) -> None: ...


class QItemModelBarDataProxy(QBarDataProxy):

    class MultiMatchBehavior(enum.Enum):
        MMBFirst = ... # type: QItemModelBarDataProxy.MultiMatchBehavior
        MMBLast = ... # type: QItemModelBarDataProxy.MultiMatchBehavior
        MMBAverage = ... # type: QItemModelBarDataProxy.MultiMatchBehavior
        MMBCumulative = ... # type: QItemModelBarDataProxy.MultiMatchBehavior

    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, valueRole: str|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, rowRole: str|None, columnRole: str|None, valueRole: str|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, rowRole: str|None, columnRole: str|None, valueRole: str|None, rotationRole: str|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, rowRole: str|None, columnRole: str|None, valueRole: str|None, rowCategories: collections.abc.Iterable[str|None], columnCategories: collections.abc.Iterable[str|None], parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, rowRole: str|None, columnRole: str|None, valueRole: str|None, rotationRole: str|None, rowCategories: collections.abc.Iterable[str|None], columnCategories: collections.abc.Iterable[str|None], parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    multiMatchBehaviorChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    valueRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    valueRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    def multiMatchBehavior(self) -> 'QItemModelBarDataProxy.MultiMatchBehavior': ...
    def setMultiMatchBehavior(self, behavior: 'QItemModelBarDataProxy.MultiMatchBehavior') -> None: ...
    def rotationRoleReplace(self) -> str: ...
    def setRotationRoleReplace(self, replace: str|None) -> None: ...
    def valueRoleReplace(self) -> str: ...
    def setValueRoleReplace(self, replace: str|None) -> None: ...
    def columnRoleReplace(self) -> str: ...
    def setColumnRoleReplace(self, replace: str|None) -> None: ...
    def rowRoleReplace(self) -> str: ...
    def setRowRoleReplace(self, replace: str|None) -> None: ...
    def rotationRolePattern(self) -> QtCore.QRegularExpression: ...
    def setRotationRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def valueRolePattern(self) -> QtCore.QRegularExpression: ...
    def setValueRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def columnRolePattern(self) -> QtCore.QRegularExpression: ...
    def setColumnRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def rowRolePattern(self) -> QtCore.QRegularExpression: ...
    def setRowRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    autoColumnCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    autoRowCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    useModelCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    valueRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemModelChanged: typing.ClassVar[QtCore.pyqtSignal]
    def remap(self, rowRole: str|None, columnRole: str|None, valueRole: str|None, rotationRole: str|None, rowCategories: collections.abc.Iterable[str|None], columnCategories: collections.abc.Iterable[str|None]) -> None: ...
    def rotationRole(self) -> str: ...
    def setRotationRole(self, role: str|None) -> None: ...
    def columnCategoryIndex(self, category: str|None) -> int: ...
    def rowCategoryIndex(self, category: str|None) -> int: ...
    def autoColumnCategories(self) -> bool: ...
    def setAutoColumnCategories(self, enable: bool) -> None: ...
    def autoRowCategories(self) -> bool: ...
    def setAutoRowCategories(self, enable: bool) -> None: ...
    def useModelCategories(self) -> bool: ...
    def setUseModelCategories(self, enable: bool) -> None: ...
    def columnCategories(self) -> list[str]: ...
    def setColumnCategories(self, categories: collections.abc.Iterable[str|None]) -> None: ...
    def rowCategories(self) -> list[str]: ...
    def setRowCategories(self, categories: collections.abc.Iterable[str|None]) -> None: ...
    def valueRole(self) -> str: ...
    def setValueRole(self, role: str|None) -> None: ...
    def columnRole(self) -> str: ...
    def setColumnRole(self, role: str|None) -> None: ...
    def rowRole(self) -> str: ...
    def setRowRole(self, role: str|None) -> None: ...
    def itemModel(self) -> QtCore.QAbstractItemModel|None: ...
    def setItemModel(self, itemModel: QtCore.QAbstractItemModel|None) -> None: ...


class QScatterDataProxy(QAbstractDataProxy):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    seriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemsInserted: typing.ClassVar[QtCore.pyqtSignal]
    itemsRemoved: typing.ClassVar[QtCore.pyqtSignal]
    itemsChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemsAdded: typing.ClassVar[QtCore.pyqtSignal]
    arrayReset: typing.ClassVar[QtCore.pyqtSignal]
    def series(self) -> 'QScatter3DSeries|None': ...
    def removeItems(self, index: int, removeCount: int) -> None: ...
    def insertItems(self, index: int, items: collections.abc.Iterable['QScatterDataItem']) -> None: ...
    def insertItem(self, index: int, item: 'QScatterDataItem') -> None: ...
    def addItems(self, items: collections.abc.Iterable['QScatterDataItem']) -> int: ...
    def addItem(self, item: 'QScatterDataItem') -> int: ...
    def setItems(self, index: int, items: collections.abc.Iterable['QScatterDataItem']) -> None: ...
    def setItem(self, index: int, item: 'QScatterDataItem') -> None: ...
    def resetArray(self, newArray: collections.abc.Iterable['QScatterDataItem']) -> None: ...
    def itemAt(self, index: int) -> 'QScatterDataItem|None': ...
    def array(self) -> list['QScatterDataItem']: ...
    def itemCount(self) -> int: ...


class QItemModelScatterDataProxy(QScatterDataProxy):

    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, xPosRole: str|None, yPosRole: str|None, zPosRole: str|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, xPosRole: str|None, yPosRole: str|None, zPosRole: str|None, rotationRole: str|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    zPosRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    yPosRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    xPosRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    zPosRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    yPosRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    xPosRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    def rotationRoleReplace(self) -> str: ...
    def setRotationRoleReplace(self, replace: str|None) -> None: ...
    def zPosRoleReplace(self) -> str: ...
    def setZPosRoleReplace(self, replace: str|None) -> None: ...
    def yPosRoleReplace(self) -> str: ...
    def setYPosRoleReplace(self, replace: str|None) -> None: ...
    def xPosRoleReplace(self) -> str: ...
    def setXPosRoleReplace(self, replace: str|None) -> None: ...
    def rotationRolePattern(self) -> QtCore.QRegularExpression: ...
    def setRotationRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def zPosRolePattern(self) -> QtCore.QRegularExpression: ...
    def setZPosRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def yPosRolePattern(self) -> QtCore.QRegularExpression: ...
    def setYPosRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def xPosRolePattern(self) -> QtCore.QRegularExpression: ...
    def setXPosRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    rotationRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    zPosRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    yPosRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    xPosRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemModelChanged: typing.ClassVar[QtCore.pyqtSignal]
    def remap(self, xPosRole: str|None, yPosRole: str|None, zPosRole: str|None, rotationRole: str|None) -> None: ...
    def rotationRole(self) -> str: ...
    def setRotationRole(self, role: str|None) -> None: ...
    def zPosRole(self) -> str: ...
    def setZPosRole(self, role: str|None) -> None: ...
    def yPosRole(self) -> str: ...
    def setYPosRole(self, role: str|None) -> None: ...
    def xPosRole(self) -> str: ...
    def setXPosRole(self, role: str|None) -> None: ...
    def itemModel(self) -> QtCore.QAbstractItemModel|None: ...
    def setItemModel(self, itemModel: QtCore.QAbstractItemModel|None) -> None: ...


class QItemModelSurfaceDataProxy(QSurfaceDataProxy):

    class MultiMatchBehavior(enum.Enum):
        MMBFirst = ... # type: QItemModelSurfaceDataProxy.MultiMatchBehavior
        MMBLast = ... # type: QItemModelSurfaceDataProxy.MultiMatchBehavior
        MMBAverage = ... # type: QItemModelSurfaceDataProxy.MultiMatchBehavior
        MMBCumulativeY = ... # type: QItemModelSurfaceDataProxy.MultiMatchBehavior

    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, yPosRole: str|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, rowRole: str|None, columnRole: str|None, yPosRole: str|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, rowRole: str|None, columnRole: str|None, yPosRole: str|None, rowCategories: collections.abc.Iterable[str|None], columnCategories: collections.abc.Iterable[str|None], parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, rowRole: str|None, columnRole: str|None, xPosRole: str|None, yPosRole: str|None, zPosRole: str|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, rowRole: str|None, columnRole: str|None, xPosRole: str|None, yPosRole: str|None, zPosRole: str|None, rowCategories: collections.abc.Iterable[str|None], columnCategories: collections.abc.Iterable[str|None], parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    multiMatchBehaviorChanged: typing.ClassVar[QtCore.pyqtSignal]
    zPosRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    yPosRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    xPosRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    zPosRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    yPosRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    xPosRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    def multiMatchBehavior(self) -> 'QItemModelSurfaceDataProxy.MultiMatchBehavior': ...
    def setMultiMatchBehavior(self, behavior: 'QItemModelSurfaceDataProxy.MultiMatchBehavior') -> None: ...
    def zPosRoleReplace(self) -> str: ...
    def setZPosRoleReplace(self, replace: str|None) -> None: ...
    def yPosRoleReplace(self) -> str: ...
    def setYPosRoleReplace(self, replace: str|None) -> None: ...
    def xPosRoleReplace(self) -> str: ...
    def setXPosRoleReplace(self, replace: str|None) -> None: ...
    def columnRoleReplace(self) -> str: ...
    def setColumnRoleReplace(self, replace: str|None) -> None: ...
    def rowRoleReplace(self) -> str: ...
    def setRowRoleReplace(self, replace: str|None) -> None: ...
    def zPosRolePattern(self) -> QtCore.QRegularExpression: ...
    def setZPosRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def yPosRolePattern(self) -> QtCore.QRegularExpression: ...
    def setYPosRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def xPosRolePattern(self) -> QtCore.QRegularExpression: ...
    def setXPosRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def columnRolePattern(self) -> QtCore.QRegularExpression: ...
    def setColumnRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def rowRolePattern(self) -> QtCore.QRegularExpression: ...
    def setRowRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    autoColumnCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    autoRowCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    useModelCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    zPosRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    yPosRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    xPosRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemModelChanged: typing.ClassVar[QtCore.pyqtSignal]
    def remap(self, rowRole: str|None, columnRole: str|None, xPosRole: str|None, yPosRole: str|None, zPosRole: str|None, rowCategories: collections.abc.Iterable[str|None], columnCategories: collections.abc.Iterable[str|None]) -> None: ...
    def zPosRole(self) -> str: ...
    def setZPosRole(self, role: str|None) -> None: ...
    def yPosRole(self) -> str: ...
    def setYPosRole(self, role: str|None) -> None: ...
    def xPosRole(self) -> str: ...
    def setXPosRole(self, role: str|None) -> None: ...
    def columnCategoryIndex(self, category: str|None) -> int: ...
    def rowCategoryIndex(self, category: str|None) -> int: ...
    def autoColumnCategories(self) -> bool: ...
    def setAutoColumnCategories(self, enable: bool) -> None: ...
    def autoRowCategories(self) -> bool: ...
    def setAutoRowCategories(self, enable: bool) -> None: ...
    def useModelCategories(self) -> bool: ...
    def setUseModelCategories(self, enable: bool) -> None: ...
    def columnCategories(self) -> list[str]: ...
    def setColumnCategories(self, categories: collections.abc.Iterable[str|None]) -> None: ...
    def rowCategories(self) -> list[str]: ...
    def setRowCategories(self, categories: collections.abc.Iterable[str|None]) -> None: ...
    def columnRole(self) -> str: ...
    def setColumnRole(self, role: str|None) -> None: ...
    def rowRole(self) -> str: ...
    def setRowRole(self, role: str|None) -> None: ...
    def itemModel(self) -> QtCore.QAbstractItemModel|None: ...
    def setItemModel(self, itemModel: QtCore.QAbstractItemModel|None) -> None: ...


class QValue3DAxisFormatter(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def locale(self) -> QtCore.QLocale: ...
    def setLocale(self, locale: QtCore.QLocale) -> None: ...
    def labelStrings(self) -> list[str]: ...
    def labelPositions(self) -> list[float]: ...
    def subGridPositions(self) -> list[float]: ...
    def gridPositions(self) -> list[float]: ...
    def axis(self) -> 'QValue3DAxis|None': ...
    def markDirty(self, labelsChange: bool = ...) -> None: ...
    def populateCopy(self, copy: 'QValue3DAxisFormatter') -> None: ...
    def valueAt(self, position: float) -> float: ...
    def positionAt(self, value: float) -> float: ...
    def stringForValue(self, value: float, format: str|None) -> str: ...
    def recalculate(self) -> None: ...
    def createNewInstance(self) -> 'QValue3DAxisFormatter|None': ...
    def allowZero(self) -> bool: ...
    def setAllowZero(self, allow: bool) -> None: ...
    def allowNegatives(self) -> bool: ...
    def setAllowNegatives(self, allow: bool) -> None: ...


class QLogValue3DAxisFormatter(QValue3DAxisFormatter):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def populateCopy(self, copy: QValue3DAxisFormatter) -> None: ...
    def valueAt(self, position: float) -> float: ...
    def positionAt(self, value: float) -> float: ...
    def recalculate(self) -> None: ...
    def createNewInstance(self) -> QValue3DAxisFormatter|None: ...
    showEdgeLabelsChanged: typing.ClassVar[QtCore.pyqtSignal]
    autoSubGridChanged: typing.ClassVar[QtCore.pyqtSignal]
    baseChanged: typing.ClassVar[QtCore.pyqtSignal]
    def showEdgeLabels(self) -> bool: ...
    def setShowEdgeLabels(self, enabled: bool) -> None: ...
    def autoSubGrid(self) -> bool: ...
    def setAutoSubGrid(self, enabled: bool) -> None: ...
    def base(self) -> float: ...
    def setBase(self, base: float) -> None: ...


class QScatter3DSeries(QAbstract3DSeries):

    @typing.overload
    def __init__(self, dataProxy: QScatterDataProxy|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    itemSizeChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedItemChanged: typing.ClassVar[QtCore.pyqtSignal]
    dataProxyChanged: typing.ClassVar[QtCore.pyqtSignal]
    def itemSize(self) -> float: ...
    def setItemSize(self, size: float) -> None: ...
    @staticmethod
    def invalidSelectionIndex() -> int: ...
    def selectedItem(self) -> int: ...
    def setSelectedItem(self, index: int) -> None: ...
    def dataProxy(self) -> QScatterDataProxy|None: ...
    def setDataProxy(self, proxy: QScatterDataProxy|None) -> None: ...


class QScatterDataItem(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, position: QtGui.QVector3D) -> None: ...
    @typing.overload
    def __init__(self, position: QtGui.QVector3D, rotation: QtGui.QQuaternion) -> None: ...
    @typing.overload
    def __init__(self, other: 'QScatterDataItem') -> None: ...

    def z(self) -> float: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def setZ(self, value: float) -> None: ...
    def setY(self, value: float) -> None: ...
    def setX(self, value: float) -> None: ...
    def rotation(self) -> QtGui.QQuaternion: ...
    def setRotation(self, rotation: QtGui.QQuaternion) -> None: ...
    def position(self) -> QtGui.QVector3D: ...
    def setPosition(self, position: QtGui.QVector3D) -> None: ...


class QSurface3DSeries(QAbstract3DSeries):

    class DrawFlag(enum.Flag):
        DrawWireframe = ... # type: QSurface3DSeries.DrawFlag
        DrawSurface = ... # type: QSurface3DSeries.DrawFlag
        DrawSurfaceAndWireframe = ... # type: QSurface3DSeries.DrawFlag

    @typing.overload
    def __init__(self, dataProxy: QSurfaceDataProxy|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    wireframeColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    def wireframeColor(self) -> QtGui.QColor: ...
    def setWireframeColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    textureFileChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureChanged: typing.ClassVar[QtCore.pyqtSignal]
    def textureFile(self) -> str: ...
    def setTextureFile(self, filename: str|None) -> None: ...
    def texture(self) -> QtGui.QImage: ...
    def setTexture(self, texture: QtGui.QImage) -> None: ...
    drawModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    flatShadingSupportedChanged: typing.ClassVar[QtCore.pyqtSignal]
    flatShadingEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedPointChanged: typing.ClassVar[QtCore.pyqtSignal]
    dataProxyChanged: typing.ClassVar[QtCore.pyqtSignal]
    def isFlatShadingSupported(self) -> bool: ...
    def drawMode(self) -> 'QSurface3DSeries.DrawFlag': ...
    def setDrawMode(self, mode: 'QSurface3DSeries.DrawFlag') -> None: ...
    def isFlatShadingEnabled(self) -> bool: ...
    def setFlatShadingEnabled(self, enabled: bool) -> None: ...
    @staticmethod
    def invalidSelectionPosition() -> QtCore.QPoint: ...
    def selectedPoint(self) -> QtCore.QPoint: ...
    def setSelectedPoint(self, position: QtCore.QPoint) -> None: ...
    def dataProxy(self) -> QSurfaceDataProxy|None: ...
    def setDataProxy(self, proxy: QSurfaceDataProxy|None) -> None: ...


class QSurfaceDataItem(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, position: QtGui.QVector3D) -> None: ...
    @typing.overload
    def __init__(self, other: 'QSurfaceDataItem') -> None: ...

    def z(self) -> float: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def setZ(self, value: float) -> None: ...
    def setY(self, value: float) -> None: ...
    def setX(self, value: float) -> None: ...
    def position(self) -> QtGui.QVector3D: ...
    def setPosition(self, position: QtGui.QVector3D) -> None: ...


class QTouch3DInputHandler(Q3DInputHandler):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def touchEvent(self, event: QtGui.QTouchEvent|None) -> None: ...


class QValue3DAxis(QAbstract3DAxis):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    reversedChanged: typing.ClassVar[QtCore.pyqtSignal]
    formatterChanged: typing.ClassVar[QtCore.pyqtSignal]
    def reversed(self) -> bool: ...
    def setReversed(self, enable: bool) -> None: ...
    def formatter(self) -> QValue3DAxisFormatter|None: ...
    def setFormatter(self, formatter: QValue3DAxisFormatter|None) -> None: ...
    labelFormatChanged: typing.ClassVar[QtCore.pyqtSignal]
    subSegmentCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    segmentCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    def labelFormat(self) -> str: ...
    def setLabelFormat(self, format: str|None) -> None: ...
    def subSegmentCount(self) -> int: ...
    def setSubSegmentCount(self, count: int) -> None: ...
    def segmentCount(self) -> int: ...
    def setSegmentCount(self, count: int) -> None: ...


PYQT_DATAVISUALIZATION_VERSION = ... # type: int
PYQT_DATAVISUALIZATION_VERSION_STR = ... # type: str


def qDefaultSurfaceFormat(antialias: bool) -> QtGui.QSurfaceFormat: ...
