/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.observability.settings.PluginSettings;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0010\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0011\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ&\u0010\u0015\u001a\u00020\u00162\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013J\u0010\u0010\u0019\u001a\u00020\u00162\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u001c\u001a\u00020\u00162\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/opensearch/observability/security/UserAccessManager;", "", "<init>", "()V", "USER_TAG", "", "ROLE_TAG", "BACKEND_ROLE_TAG", "ALL_ACCESS_ROLE", "OPENSEARCH_DASHBOARDS_SERVER_USER", "PRIVATE_TENANT", "DEFAULT_TENANT", "validateUser", "", "user", "Lorg/opensearch/commons/authuser/User;", "validatePollingUser", "getUserTenant", "getAllAccessInfo", "", "getSearchAccessInfo", "doesUserHasAccess", "", "tenant", "access", "hasAllInfoAccess", "canAdminViewAllItems", "isAdminUser", "isUserPrivateTenant", "opensearch-observability"})
@SourceDebugExtension(value={"SMAP\nUserAccessManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserAccessManager.kt\norg/opensearch/observability/security/UserAccessManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,220:1\n1869#2,2:221\n1869#2,2:223\n1563#2:225\n1634#2,3:226\n1563#2:229\n1634#2,3:230\n1761#2,3:233\n*S KotlinDebug\n*F\n+ 1 UserAccessManager.kt\norg/opensearch/observability/security/UserAccessManager\n*L\n117#1:221,2\n118#1:223,2\n153#1:225\n153#1:226,3\n196#1:229\n196#1:230,3\n196#1:233,3\n*E\n"})
public final class UserAccessManager {
    @NotNull
    public static final UserAccessManager INSTANCE = new UserAccessManager();
    @NotNull
    private static final String USER_TAG = "User:";
    @NotNull
    private static final String ROLE_TAG = "Role:";
    @NotNull
    private static final String BACKEND_ROLE_TAG = "BERole:";
    @NotNull
    private static final String ALL_ACCESS_ROLE = "all_access";
    @NotNull
    private static final String OPENSEARCH_DASHBOARDS_SERVER_USER = "opensearchdashboardsserver";
    @NotNull
    private static final String PRIVATE_TENANT = "__user__";
    @NotNull
    public static final String DEFAULT_TENANT = "";

    private UserAccessManager() {
    }

    public final void validateUser(@Nullable User user) {
        if (this.isUserPrivateTenant(user)) {
            User user2 = user;
            if ((user2 != null ? user2.getName() : null) == null) {
                throw new OpenSearchStatusException("User name not provided for private tenant access", RestStatus.FORBIDDEN, new Object[0]);
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$0[PluginSettings.INSTANCE.getFilterBy().ordinal()]) {
            case 1: {
                Object object = Unit.INSTANCE;
                break;
            }
            case 2: {
                Object object = user;
                if (object != null && (object = object.getName()) != null) break;
                throw new OpenSearchStatusException("Filter-by enabled with security disabled", RestStatus.FORBIDDEN, new Object[0]);
            }
            case 3: {
                Collection collection;
                if (user == null || (collection = (Collection)user.getRoles()) == null || collection.isEmpty()) {
                    throw new OpenSearchStatusException("User doesn't have roles configured. Contact administrator.", RestStatus.FORBIDDEN, new Object[0]);
                }
                if (user.getRoles().stream().filter(arg_0 -> UserAccessManager.validateUser$lambda$1(UserAccessManager::validateUser$lambda$0, arg_0)).count() == 0L) {
                    throw new OpenSearchStatusException("No distinguishing roles configured. Contact administrator.", RestStatus.FORBIDDEN, new Object[0]);
                }
                Object object = Unit.INSTANCE;
                break;
            }
            case 4: {
                User user3 = user;
                Collection collection = user3 != null ? user3.getBackendRoles() : null;
                if (collection == null || collection.isEmpty()) {
                    throw new OpenSearchStatusException("User doesn't have backend roles configured. Contact administrator.", RestStatus.FORBIDDEN, new Object[0]);
                }
                Object object = Unit.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void validatePollingUser(@Nullable User user) {
        if (user != null && !Intrinsics.areEqual((Object)user.getName(), (Object)OPENSEARCH_DASHBOARDS_SERVER_USER)) {
            throw new OpenSearchStatusException("Permission denied", RestStatus.FORBIDDEN, new Object[0]);
        }
    }

    @NotNull
    public final String getUserTenant(@Nullable User user) {
        String requestedTenant;
        Object object = user;
        if (object == null || (object = (requestedTenant = object.getRequestedTenant())) == null) {
            object = DEFAULT_TENANT;
        }
        return object;
    }

    @NotNull
    public final List<String> getAllAccessInfo(@Nullable User user) {
        String it;
        if (user == null) {
            return CollectionsKt.emptyList();
        }
        List retList = new ArrayList();
        if (user.getName() != null) {
            retList.add(USER_TAG + user.getName());
        }
        List list = user.getRoles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRoles(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            retList.add(ROLE_TAG + it);
        }
        List list2 = user.getBackendRoles();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getBackendRoles(...)");
        $this$forEach$iv = list2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            retList.add(BACKEND_ROLE_TAG + it);
        }
        return retList;
    }

    @NotNull
    public final List<String> getSearchAccessInfo(@Nullable User user) {
        if (user == null) {
            return CollectionsKt.emptyList();
        }
        if (this.isUserPrivateTenant(user)) {
            return CollectionsKt.listOf((Object)(USER_TAG + user.getName()));
        }
        if (this.canAdminViewAllItems(user)) {
            return CollectionsKt.emptyList();
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[PluginSettings.INSTANCE.getFilterBy().ordinal()]) {
            case 1 -> CollectionsKt.emptyList();
            case 2 -> CollectionsKt.listOf((Object)(USER_TAG + user.getName()));
            case 3 -> {
                List var2_2 = user.getRoles().stream().filter(arg_0 -> UserAccessManager.getSearchAccessInfo$lambda$5(UserAccessManager::getSearchAccessInfo$lambda$4, arg_0)).map(arg_0 -> UserAccessManager.getSearchAccessInfo$lambda$7(UserAccessManager::getSearchAccessInfo$lambda$6, arg_0)).collect(Collectors.toList());
                Intrinsics.checkNotNull(var2_2);
                yield var2_2;
            }
            case 4 -> {
                void $this$mapTo$iv$iv;
                List v1 = user.getBackendRoles();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getBackendRoles(...)");
                Iterable $this$map$iv = v1;
                boolean $i$f$map = false;
                Iterable var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String var9_10 = (String)item$iv$iv;
                    Collection var11_12 = destination$iv$iv;
                    boolean $i$a$-map-UserAccessManager$getSearchAccessInfo$3 = false;
                    var11_12.add(BACKEND_ROLE_TAG + (String)it);
                }
                yield (List)destination$iv$iv;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final boolean doesUserHasAccess(@Nullable User user, @NotNull String tenant, @NotNull List<String> access) {
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        if (user == null) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)this.getUserTenant(user), (Object)tenant)) {
            return false;
        }
        if (this.isUserPrivateTenant(user)) {
            return access.contains(USER_TAG + user.getName());
        }
        if (this.canAdminViewAllItems(user)) {
            return true;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[PluginSettings.INSTANCE.getFilterBy().ordinal()]) {
            case 1 -> true;
            case 2 -> access.contains(USER_TAG + user.getName());
            case 3 -> user.getRoles().stream().filter(arg_0 -> UserAccessManager.doesUserHasAccess$lambda$10(UserAccessManager::doesUserHasAccess$lambda$9, arg_0)).map(arg_0 -> UserAccessManager.doesUserHasAccess$lambda$12(UserAccessManager::doesUserHasAccess$lambda$11, arg_0)).anyMatch(arg_0 -> UserAccessManager.doesUserHasAccess$lambda$14(arg_0 -> UserAccessManager.doesUserHasAccess$lambda$13(access, arg_0), arg_0));
            case 4 -> {
                void $this$any$iv;
                void $this$mapTo$iv$iv;
                List v1 = user.getBackendRoles();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getBackendRoles(...)");
                Iterable $this$map$iv = v1;
                boolean $i$f$map = false;
                Iterable var6_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String var11_13 = (String)item$iv$iv;
                    Collection var13_15 = destination$iv$iv;
                    boolean $i$a$-map-UserAccessManager$doesUserHasAccess$4 = false;
                    var13_15.add(BACKEND_ROLE_TAG + (String)it);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    yield false;
                }
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean $i$a$-any-UserAccessManager$doesUserHasAccess$5 = false;
                    if (!access.contains(it)) continue;
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final boolean hasAllInfoAccess(@Nullable User user) {
        if (user == null) {
            return true;
        }
        return this.isAdminUser(user);
    }

    private final boolean canAdminViewAllItems(User user) {
        return PluginSettings.INSTANCE.getAdminAccess() == PluginSettings.AdminAccess.AllObservabilityObjects && this.isAdminUser(user);
    }

    private final boolean isAdminUser(User user) {
        return user.getRoles().contains(ALL_ACCESS_ROLE);
    }

    private final boolean isUserPrivateTenant(User user) {
        return Intrinsics.areEqual((Object)this.getUserTenant(user), (Object)PRIVATE_TENANT);
    }

    private static final boolean validateUser$lambda$0(String it) {
        return !PluginSettings.INSTANCE.getIgnoredRoles().contains(it);
    }

    private static final boolean validateUser$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getSearchAccessInfo$lambda$4(String it) {
        return !PluginSettings.INSTANCE.getIgnoredRoles().contains(it);
    }

    private static final boolean getSearchAccessInfo$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String getSearchAccessInfo$lambda$6(String it) {
        return ROLE_TAG + it;
    }

    private static final String getSearchAccessInfo$lambda$7(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final boolean doesUserHasAccess$lambda$9(String it) {
        return !PluginSettings.INSTANCE.getIgnoredRoles().contains(it);
    }

    private static final boolean doesUserHasAccess$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String doesUserHasAccess$lambda$11(String it) {
        return ROLE_TAG + it;
    }

    private static final String doesUserHasAccess$lambda$12(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final boolean doesUserHasAccess$lambda$13(List $access, String it) {
        return $access.contains(it);
    }

    private static final boolean doesUserHasAccess$lambda$14(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PluginSettings.FilterBy.values().length];
            try {
                nArray[PluginSettings.FilterBy.NoFilter.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PluginSettings.FilterBy.User.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PluginSettings.FilterBy.Roles.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PluginSettings.FilterBy.BackendRoles.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

