/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.ndarray.index.full;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.index.NDIndex;
import ai.djl.ndarray.index.dim.NDIndexAll;
import ai.djl.ndarray.index.dim.NDIndexElement;
import ai.djl.ndarray.index.dim.NDIndexPick;
import ai.djl.ndarray.types.Shape;
import java.util.Optional;

public final class NDIndexFullPick {
    private NDArray indices;
    private int axis;

    private NDIndexFullPick(NDArray indices, int axis) {
        this.indices = indices;
        this.axis = axis;
    }

    public static Optional<NDIndexFullPick> fromIndex(NDIndex index, Shape target) {
        int axis = 0;
        NDIndexFullPick fullPick = null;
        for (NDIndexElement el : index.getIndices()) {
            if (el instanceof NDIndexAll) {
                ++axis;
                continue;
            }
            if (el instanceof NDIndexPick) {
                if (fullPick != null) {
                    throw new UnsupportedOperationException("Only one pick per get is currently supported. Check if the array index is supposed to be boolean index. If so, remember to change the datatype of index to boolean. Or you can explicitly do new NDIndex().addBooleanIndex(array)");
                }
                NDArray indexElem = ((NDIndexPick)el).getIndex();
                fullPick = new NDIndexFullPick(indexElem, axis);
                continue;
            }
            return Optional.empty();
        }
        return Optional.ofNullable(fullPick);
    }

    public NDArray getIndices() {
        return this.indices;
    }

    public int getAxis() {
        return this.axis;
    }
}

