/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.hibernate;

import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.AjaxFilterChain;
import org.directwebremoting.WebContextFactory;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public class H3SessionAjaxFilter
implements AjaxFilter {
    private static final Log log = LogFactory.getLog(H3SessionAjaxFilter.class);
    protected static final String ATTRIBUTE_SESSION = "org.directwebremoting.hibernate.SessionFactory";

    @Override
    public Object doFilter(Object object, Method method, Object[] params, AjaxFilterChain chain) throws Exception {
        ServletContext context = WebContextFactory.get().getServletContext();
        SessionFactory sessionFactory = (SessionFactory)context.getAttribute(ATTRIBUTE_SESSION);
        Transaction transaction = null;
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            transaction = session.beginTransaction();
        } else {
            log.error((Object)"SessionFactory not initialized for this web application. Use: H3SessionAjaxFilter.setSessionFactory(servletContext, sessionFactory);");
        }
        Object reply = chain.doFilter(object, method, params);
        if (transaction != null) {
            transaction.commit();
        }
        return reply;
    }

    public static void setSessionFactory(ServletContext context, SessionFactory sessionFactory) {
        context.setAttribute(ATTRIBUTE_SESSION, (Object)sessionFactory);
    }

    public static org.hibernate.Session getCurrentSession(ServletContext context) {
        SessionFactory sessionFactory = (SessionFactory)context.getAttribute(ATTRIBUTE_SESSION);
        if (sessionFactory == null) {
            return null;
        }
        return sessionFactory.getCurrentSession();
    }
}

