/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.compare;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.openapitools.openapidiff.core.compare.ListDiff;
import org.openapitools.openapidiff.core.compare.OpenApiDiff;
import org.openapitools.openapidiff.core.compare.ReferenceDiffCache;
import org.openapitools.openapidiff.core.model.ChangedSecurityScheme;
import org.openapitools.openapidiff.core.model.ChangedSecuritySchemeScopes;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.deferred.DeferredChanged;
import org.openapitools.openapidiff.core.model.deferred.RealizedChanged;
import org.openapitools.openapidiff.core.utils.ChangedUtils;

public class SecuritySchemeDiff
extends ReferenceDiffCache<SecurityScheme, ChangedSecurityScheme> {
    private final OpenApiDiff openApiDiff;
    private final Components leftComponents;
    private final Components rightComponents;

    public SecuritySchemeDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
        this.leftComponents = openApiDiff.getOldSpecOpenApi() != null ? openApiDiff.getOldSpecOpenApi().getComponents() : null;
        this.rightComponents = openApiDiff.getNewSpecOpenApi() != null ? openApiDiff.getNewSpecOpenApi().getComponents() : null;
    }

    public DeferredChanged<ChangedSecurityScheme> diff(String leftSchemeRef, List<String> leftScopes, String rightSchemeRef, List<String> rightScopes, DiffContext context) {
        SecurityScheme leftSecurityScheme = this.leftComponents.getSecuritySchemes().get(leftSchemeRef);
        SecurityScheme rightSecurityScheme = this.rightComponents.getSecuritySchemes().get(rightSchemeRef);
        DeferredChanged changedSecuritySchemeOpt = this.cachedDiff(new HashSet<String>(), leftSecurityScheme, rightSecurityScheme, leftSchemeRef, rightSchemeRef, context);
        return changedSecuritySchemeOpt.map(changedSecuritySchemeOptional -> {
            ChangedSecurityScheme changedSecurityScheme = changedSecuritySchemeOptional.orElse(new ChangedSecurityScheme(leftSecurityScheme, rightSecurityScheme, context));
            if ((changedSecurityScheme = this.getCopyWithoutScopes(changedSecurityScheme, context)) != null && leftSecurityScheme.getType() == SecurityScheme.Type.OAUTH2) {
                ChangedUtils.isChanged(ListDiff.diff(new ChangedSecuritySchemeScopes(leftScopes, rightScopes))).ifPresent(changedSecurityScheme::setChangedScopes);
            }
            return changedSecurityScheme;
        });
    }

    @Override
    protected DeferredChanged<ChangedSecurityScheme> computeDiff(HashSet<String> refSet, SecurityScheme leftSecurityScheme, SecurityScheme rightSecurityScheme, DiffContext context) {
        ChangedSecurityScheme changedSecurityScheme = new ChangedSecurityScheme(leftSecurityScheme, rightSecurityScheme, context);
        this.openApiDiff.getMetadataDiff().diff(leftSecurityScheme.getDescription(), rightSecurityScheme.getDescription(), context).ifPresent(changedSecurityScheme::setDescription);
        switch (leftSecurityScheme.getType()) {
            case APIKEY: {
                changedSecurityScheme.setChangedIn(!Objects.equals((Object)leftSecurityScheme.getIn(), (Object)rightSecurityScheme.getIn()));
                break;
            }
            case OAUTH2: {
                this.openApiDiff.getOAuthFlowsDiff().diff(leftSecurityScheme.getFlows(), rightSecurityScheme.getFlows(), context).ifPresent(changedSecurityScheme::setOAuthFlows);
                break;
            }
            case HTTP: {
                changedSecurityScheme.setChangedScheme(!Objects.equals(leftSecurityScheme.getScheme(), rightSecurityScheme.getScheme()));
                changedSecurityScheme.setChangedBearerFormat(!Objects.equals(leftSecurityScheme.getBearerFormat(), rightSecurityScheme.getBearerFormat()));
                break;
            }
            case OPENIDCONNECT: {
                changedSecurityScheme.setChangedOpenIdConnectUrl(!Objects.equals(leftSecurityScheme.getOpenIdConnectUrl(), rightSecurityScheme.getOpenIdConnectUrl()));
            }
        }
        this.openApiDiff.getExtensionsDiff().diff(leftSecurityScheme.getExtensions(), rightSecurityScheme.getExtensions(), context).ifPresent(changedSecurityScheme::setExtensions);
        return new RealizedChanged<ChangedSecurityScheme>(changedSecurityScheme);
    }

    private ChangedSecurityScheme getCopyWithoutScopes(ChangedSecurityScheme original, DiffContext context) {
        return new ChangedSecurityScheme(original.getOldSecurityScheme(), original.getNewSecurityScheme(), context).setChangedType(original.isChangedType()).setChangedIn(original.isChangedIn()).setChangedScheme(original.isChangedScheme()).setChangedBearerFormat(original.isChangedBearerFormat()).setDescription(original.getDescription()).setOAuthFlows(original.getOAuthFlows()).setChangedOpenIdConnectUrl(original.isChangedOpenIdConnectUrl());
    }
}

