/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.lang.ref.Cleaner;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class ComposeMatrixNode extends ImplicitNode {

	public ComposeMatrixNode(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Retrieves the input for the element 0 0
	 *
	 * @return the input for the m00 element
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputM00() throws Lib3MFException {
		Pointer bufferM00 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_composematrixnode_getinputm00.invokeInt(new java.lang.Object[]{mHandle, bufferM00}));
		Pointer valueM00 = bufferM00.getPointer(0);
		ImplicitPort m00 = null;
		if (valueM00 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "M00 was a null pointer");
		}
		m00 = mWrapper.PolymorphicFactory(valueM00, ImplicitPort.class);
		return m00;
	}

	/**
	 * Retrieves the input for the element 0 1
	 *
	 * @return the input for the m01 element
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputM01() throws Lib3MFException {
		Pointer bufferM01 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_composematrixnode_getinputm01.invokeInt(new java.lang.Object[]{mHandle, bufferM01}));
		Pointer valueM01 = bufferM01.getPointer(0);
		ImplicitPort m01 = null;
		if (valueM01 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "M01 was a null pointer");
		}
		m01 = mWrapper.PolymorphicFactory(valueM01, ImplicitPort.class);
		return m01;
	}

	/**
	 * Retrieves the input for the element 0 2
	 *
	 * @return the input for the m02 element
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputM02() throws Lib3MFException {
		Pointer bufferM02 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_composematrixnode_getinputm02.invokeInt(new java.lang.Object[]{mHandle, bufferM02}));
		Pointer valueM02 = bufferM02.getPointer(0);
		ImplicitPort m02 = null;
		if (valueM02 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "M02 was a null pointer");
		}
		m02 = mWrapper.PolymorphicFactory(valueM02, ImplicitPort.class);
		return m02;
	}

	/**
	 * Retrieves the input for the element 0 3
	 *
	 * @return the input for the m03 element
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputM03() throws Lib3MFException {
		Pointer bufferM03 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_composematrixnode_getinputm03.invokeInt(new java.lang.Object[]{mHandle, bufferM03}));
		Pointer valueM03 = bufferM03.getPointer(0);
		ImplicitPort m03 = null;
		if (valueM03 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "M03 was a null pointer");
		}
		m03 = mWrapper.PolymorphicFactory(valueM03, ImplicitPort.class);
		return m03;
	}

	/**
	 * Retrieves the input for the element 1 0
	 *
	 * @return the input for the m10 element
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputM10() throws Lib3MFException {
		Pointer bufferM10 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_composematrixnode_getinputm10.invokeInt(new java.lang.Object[]{mHandle, bufferM10}));
		Pointer valueM10 = bufferM10.getPointer(0);
		ImplicitPort m10 = null;
		if (valueM10 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "M10 was a null pointer");
		}
		m10 = mWrapper.PolymorphicFactory(valueM10, ImplicitPort.class);
		return m10;
	}

	/**
	 * Retrieves the input for the element 1 1
	 *
	 * @return the input for the m11 element
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputM11() throws Lib3MFException {
		Pointer bufferM11 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_composematrixnode_getinputm11.invokeInt(new java.lang.Object[]{mHandle, bufferM11}));
		Pointer valueM11 = bufferM11.getPointer(0);
		ImplicitPort m11 = null;
		if (valueM11 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "M11 was a null pointer");
		}
		m11 = mWrapper.PolymorphicFactory(valueM11, ImplicitPort.class);
		return m11;
	}

	/**
	 * Retrieves the input for the element 1 2
	 *
	 * @return the input for the m12 element
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputM12() throws Lib3MFException {
		Pointer bufferM12 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_composematrixnode_getinputm12.invokeInt(new java.lang.Object[]{mHandle, bufferM12}));
		Pointer valueM12 = bufferM12.getPointer(0);
		ImplicitPort m12 = null;
		if (valueM12 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "M12 was a null pointer");
		}
		m12 = mWrapper.PolymorphicFactory(valueM12, ImplicitPort.class);
		return m12;
	}

	/**
	 * Retrieves the input for the element 1 3
	 *
	 * @return the input for the m13 element
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputM13() throws Lib3MFException {
		Pointer bufferM13 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_composematrixnode_getinputm13.invokeInt(new java.lang.Object[]{mHandle, bufferM13}));
		Pointer valueM13 = bufferM13.getPointer(0);
		ImplicitPort m13 = null;
		if (valueM13 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "M13 was a null pointer");
		}
		m13 = mWrapper.PolymorphicFactory(valueM13, ImplicitPort.class);
		return m13;
	}

	/**
	 * Retrieves the input for the element 2 0
	 *
	 * @return the input for the m20 element
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputM20() throws Lib3MFException {
		Pointer bufferM20 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_composematrixnode_getinputm20.invokeInt(new java.lang.Object[]{mHandle, bufferM20}));
		Pointer valueM20 = bufferM20.getPointer(0);
		ImplicitPort m20 = null;
		if (valueM20 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "M20 was a null pointer");
		}
		m20 = mWrapper.PolymorphicFactory(valueM20, ImplicitPort.class);
		return m20;
	}

	/**
	 * Retrieves the input for the element 2 1
	 *
	 * @return 
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputM21() throws Lib3MFException {
		Pointer bufferM21 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_composematrixnode_getinputm21.invokeInt(new java.lang.Object[]{mHandle, bufferM21}));
		Pointer valueM21 = bufferM21.getPointer(0);
		ImplicitPort m21 = null;
		if (valueM21 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "M21 was a null pointer");
		}
		m21 = mWrapper.PolymorphicFactory(valueM21, ImplicitPort.class);
		return m21;
	}

	/**
	 * Retrieves the input for the element 2 2
	 *
	 * @return the input for the m22 element
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputM22() throws Lib3MFException {
		Pointer bufferM22 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_composematrixnode_getinputm22.invokeInt(new java.lang.Object[]{mHandle, bufferM22}));
		Pointer valueM22 = bufferM22.getPointer(0);
		ImplicitPort m22 = null;
		if (valueM22 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "M22 was a null pointer");
		}
		m22 = mWrapper.PolymorphicFactory(valueM22, ImplicitPort.class);
		return m22;
	}

	/**
	 * Retrieves the input for the element 2 3
	 *
	 * @return the input for the m23 element
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputM23() throws Lib3MFException {
		Pointer bufferM23 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_composematrixnode_getinputm23.invokeInt(new java.lang.Object[]{mHandle, bufferM23}));
		Pointer valueM23 = bufferM23.getPointer(0);
		ImplicitPort m23 = null;
		if (valueM23 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "M23 was a null pointer");
		}
		m23 = mWrapper.PolymorphicFactory(valueM23, ImplicitPort.class);
		return m23;
	}

	/**
	 * Retrieves the input for the element 3 0
	 *
	 * @return the input for the m30 element
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputM30() throws Lib3MFException {
		Pointer bufferM30 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_composematrixnode_getinputm30.invokeInt(new java.lang.Object[]{mHandle, bufferM30}));
		Pointer valueM30 = bufferM30.getPointer(0);
		ImplicitPort m30 = null;
		if (valueM30 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "M30 was a null pointer");
		}
		m30 = mWrapper.PolymorphicFactory(valueM30, ImplicitPort.class);
		return m30;
	}

	/**
	 * Retrieves the input for the element 3 1
	 *
	 * @return the input for the m31 element
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputM31() throws Lib3MFException {
		Pointer bufferM31 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_composematrixnode_getinputm31.invokeInt(new java.lang.Object[]{mHandle, bufferM31}));
		Pointer valueM31 = bufferM31.getPointer(0);
		ImplicitPort m31 = null;
		if (valueM31 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "M31 was a null pointer");
		}
		m31 = mWrapper.PolymorphicFactory(valueM31, ImplicitPort.class);
		return m31;
	}

	/**
	 * Retrieves the input for the element 3 2
	 *
	 * @return the input for the m32 element
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputM32() throws Lib3MFException {
		Pointer bufferM32 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_composematrixnode_getinputm32.invokeInt(new java.lang.Object[]{mHandle, bufferM32}));
		Pointer valueM32 = bufferM32.getPointer(0);
		ImplicitPort m32 = null;
		if (valueM32 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "M32 was a null pointer");
		}
		m32 = mWrapper.PolymorphicFactory(valueM32, ImplicitPort.class);
		return m32;
	}

	/**
	 * Retrieves the input for the element 3 3
	 *
	 * @return the input for the m33 element
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputM33() throws Lib3MFException {
		Pointer bufferM33 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_composematrixnode_getinputm33.invokeInt(new java.lang.Object[]{mHandle, bufferM33}));
		Pointer valueM33 = bufferM33.getPointer(0);
		ImplicitPort m33 = null;
		if (valueM33 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "M33 was a null pointer");
		}
		m33 = mWrapper.PolymorphicFactory(valueM33, ImplicitPort.class);
		return m33;
	}

	/**
	 * Retrieves the output
	 *
	 * @return the output
	 * @throws Lib3MFException
	 */
	public ImplicitPort getOutputResult() throws Lib3MFException {
		Pointer bufferResult = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_composematrixnode_getoutputresult.invokeInt(new java.lang.Object[]{mHandle, bufferResult}));
		Pointer valueResult = bufferResult.getPointer(0);
		ImplicitPort result = null;
		if (valueResult == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Result was a null pointer");
		}
		result = mWrapper.PolymorphicFactory(valueResult, ImplicitPort.class);
		return result;
	}


}

