/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.darwin;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum Fcntl implements Constant
{
    FAPPEND(8L),
    FREAD(1L),
    FWRITE(2L),
    FASYNC(64L),
    FFSYNC(128L),
    FNONBLOCK(4L),
    FNDELAY(4L),
    F_DUPFD(0L),
    F_GETFD(1L),
    F_SETFD(2L),
    F_GETFL(3L),
    F_SETFL(4L),
    F_GETOWN(5L),
    F_SETOWN(6L),
    F_GETLK(7L),
    F_SETLK(8L),
    F_SETLKW(9L),
    F_CHKCLEAN(41L),
    F_PREALLOCATE(42L),
    F_SETSIZE(43L),
    F_RDADVISE(44L),
    F_RDAHEAD(45L),
    F_NOCACHE(48L),
    F_LOG2PHYS(49L),
    F_GETPATH(50L),
    F_FULLFSYNC(51L),
    F_PATHPKG_CHECK(52L),
    F_FREEZE_FS(53L),
    F_THAW_FS(54L),
    F_GLOBAL_NOCACHE(55L),
    F_ADDSIGS(59L),
    F_RDLCK(1L),
    F_UNLCK(2L),
    F_WRLCK(3L),
    F_ALLOCATECONTIG(2L),
    F_ALLOCATEALL(4L);

    private final long value;
    public static final long MIN_VALUE = 0L;
    public static final long MAX_VALUE = 128L;

    private Fcntl(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<Fcntl, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<Fcntl, String> generateTable() {
            EnumMap<Fcntl, String> map2 = new EnumMap<Fcntl, String>(Fcntl.class);
            map2.put(FAPPEND, "FAPPEND");
            map2.put(FREAD, "FREAD");
            map2.put(FWRITE, "FWRITE");
            map2.put(FASYNC, "FASYNC");
            map2.put(FFSYNC, "FFSYNC");
            map2.put(FNONBLOCK, "FNONBLOCK");
            map2.put(FNDELAY, "FNDELAY");
            map2.put(F_DUPFD, "F_DUPFD");
            map2.put(F_GETFD, "F_GETFD");
            map2.put(F_SETFD, "F_SETFD");
            map2.put(F_GETFL, "F_GETFL");
            map2.put(F_SETFL, "F_SETFL");
            map2.put(F_GETOWN, "F_GETOWN");
            map2.put(F_SETOWN, "F_SETOWN");
            map2.put(F_GETLK, "F_GETLK");
            map2.put(F_SETLK, "F_SETLK");
            map2.put(F_SETLKW, "F_SETLKW");
            map2.put(F_CHKCLEAN, "F_CHKCLEAN");
            map2.put(F_PREALLOCATE, "F_PREALLOCATE");
            map2.put(F_SETSIZE, "F_SETSIZE");
            map2.put(F_RDADVISE, "F_RDADVISE");
            map2.put(F_RDAHEAD, "F_RDAHEAD");
            map2.put(F_NOCACHE, "F_NOCACHE");
            map2.put(F_LOG2PHYS, "F_LOG2PHYS");
            map2.put(F_GETPATH, "F_GETPATH");
            map2.put(F_FULLFSYNC, "F_FULLFSYNC");
            map2.put(F_PATHPKG_CHECK, "F_PATHPKG_CHECK");
            map2.put(F_FREEZE_FS, "F_FREEZE_FS");
            map2.put(F_THAW_FS, "F_THAW_FS");
            map2.put(F_GLOBAL_NOCACHE, "F_GLOBAL_NOCACHE");
            map2.put(F_ADDSIGS, "F_ADDSIGS");
            map2.put(F_RDLCK, "F_RDLCK");
            map2.put(F_UNLCK, "F_UNLCK");
            map2.put(F_WRLCK, "F_WRLCK");
            map2.put(F_ALLOCATECONTIG, "F_ALLOCATECONTIG");
            map2.put(F_ALLOCATEALL, "F_ALLOCATEALL");
            return map2;
        }
    }
}

