/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;

public final class Font2DTest
extends JPanel
implements ActionListener,
ItemListener,
ChangeListener {
    private final JFrame parent;
    private final FontPanel fp;
    private final RangeMenu rm;
    private final ChoiceV2 fontMenu;
    private JPanel fontMenuPanel;
    private JPanel stylePanel;
    private LabelV2 fontMenuLabel = null;
    private LabelV2 styleLabel = null;
    private ChoiceV2 fontNameMenu;
    private ChoiceV2 fontSubFamilyMenu;
    private final JTextField sizeField;
    private final ChoiceV2 styleMenu;
    private final ChoiceV2 textMenu;
    private int currentTextChoice = 0;
    private final ChoiceV2 transformMenu;
    private final ChoiceV2 transformMenuG2;
    private final ChoiceV2 methodsMenu;
    private final JComboBox<FontPanel.AAValues> antiAliasMenu;
    private final JComboBox<FontPanel.FMValues> fracMetricsMenu;
    private final JSlider contrastSlider;
    private CheckboxMenuItemV2 displayGridCBMI;
    private CheckboxMenuItemV2 force16ColsCBMI;
    private CheckboxMenuItemV2 showFontInfoCBMI;
    private JRadioButtonMenuItem familyAndStyleRBMI;
    private JRadioButtonMenuItem familyAndSubFamilyRBMI;
    private JRadioButtonMenuItem fontNameRBMI;
    private JDialog userTextDialog;
    private JTextArea userTextArea;
    private JDialog printDialog;
    private JDialog fontInfoDialog;
    private LabelV2[] fontInfos = new LabelV2[2];
    private JFileChooser filePromptDialog = null;
    private ButtonGroup printCBGroup;
    private JRadioButton[] printModeCBs = new JRadioButton[3];
    private final LabelV2 statusBar;
    private String currentFontName = "Dialog";
    private int[] fontStyles = new int[]{0, 1, 2, 3};
    private String tFileName;
    private static boolean canDisplayCheck = true;
    private static final Locale l = Locale.getDefault();
    static final int FAMILY_AND_STYLE = 1;
    static final int FONT_NAME = 2;
    static final int FAMILY_AND_SUBFAMILY = 3;
    static int fontSelectionType = 1;
    static final String FAMILY_LABEL_TEXT = "Font Family:";
    static final String NAME_LABEL_TEXT = "Font Name:";
    static final String STYLE_LABEL_TEXT = "Style:";
    static final String SUBFAMILY_LABEL_TEXT = "Subfamily:";
    static String[] familyNames;
    static Font[] allFonts;
    static List<String> allFontNames;
    static Map<String, FontFamily> familyMap;

    public Font2DTest(JFrame f) {
        this.parent = f;
        this.rm = new RangeMenu(this, this.parent);
        this.fp = new FontPanel(this, this.parent);
        this.statusBar = new LabelV2(this, "");
        this.fontMenu = new ChoiceV2(this, this, canDisplayCheck);
        this.fontNameMenu = new ChoiceV2(this, this, false);
        this.fontSubFamilyMenu = new ChoiceV2(this, this, false);
        this.sizeField = new JTextField("12", 3);
        this.sizeField.addActionListener(this);
        this.styleMenu = new ChoiceV2(this, this);
        this.textMenu = new ChoiceV2(this);
        this.transformMenu = new ChoiceV2(this, this);
        this.transformMenuG2 = new ChoiceV2(this, this);
        this.methodsMenu = new ChoiceV2(this, this);
        this.antiAliasMenu = new JComboBox<FontPanel.AAValues>(FontPanel.AAValues.values());
        this.antiAliasMenu.addActionListener(this);
        this.fracMetricsMenu = new JComboBox<FontPanel.FMValues>(FontPanel.FMValues.values());
        this.fracMetricsMenu.addActionListener(this);
        this.contrastSlider = new JSlider(0, 100, 250, FontPanel.getDefaultLCDContrast());
        this.contrastSlider.setEnabled(false);
        this.contrastSlider.setMajorTickSpacing(20);
        this.contrastSlider.setMinorTickSpacing(10);
        this.contrastSlider.setPaintTicks(true);
        this.contrastSlider.setPaintLabels(true);
        this.contrastSlider.addChangeListener(this);
        this.setupPanel();
        this.setupMenu();
        this.setupDialog();
        if (canDisplayCheck) {
            this.fireRangeChanged();
        }
    }

    private void addFontMenuToGBL(String labelText, JComponent menuContainer, GridBagLayout gbl, GridBagConstraints gbc, int leftInset, Container target) {
        this.fontMenuLabel = new LabelV2(this, labelText);
        this.fontMenuLabel.setLabelFor(menuContainer);
        GridBagConstraints gbcLabel = (GridBagConstraints)gbc.clone();
        gbcLabel.insets = new Insets(2, leftInset, 2, 0);
        gbcLabel.gridwidth = 1;
        gbcLabel.weightx = 0.0;
        gbcLabel.anchor = 13;
        gbl.setConstraints(this.fontMenuLabel, gbcLabel);
        target.add(this.fontMenuLabel);
        gbl.setConstraints(menuContainer, gbc);
        target.add(menuContainer);
    }

    private void addStyleMenuToGBL(String labelText, JComponent menuContainer, GridBagLayout gbl, GridBagConstraints gbc, int leftInset, Container target) {
        this.styleLabel = new LabelV2(this, labelText);
        this.styleLabel.setLabelFor(menuContainer);
        GridBagConstraints gbcLabel = (GridBagConstraints)gbc.clone();
        gbcLabel.insets = new Insets(2, leftInset, 2, 0);
        gbcLabel.gridwidth = 1;
        gbcLabel.weightx = 0.0;
        gbcLabel.anchor = 13;
        gbl.setConstraints(this.styleLabel, gbcLabel);
        target.add(this.styleLabel);
        gbl.setConstraints(menuContainer, gbc);
        target.add(menuContainer);
    }

    private void setupPanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 0, 2, 2);
        this.setLayout(gbl);
        this.fontMenuPanel = new JPanel();
        this.fontMenuPanel.setLayout(new GridLayout());
        this.fontMenuPanel.add(this.fontMenu);
        this.addFontMenuToGBL(FAMILY_LABEL_TEXT, this.fontMenuPanel, gbl, gbc, 2, this);
        this.stylePanel = new JPanel();
        this.stylePanel.setLayout(new GridLayout());
        this.stylePanel.add(this.styleMenu);
        this.addStyleMenuToGBL(STYLE_LABEL_TEXT, this.stylePanel, gbl, gbc, 40, this);
        gbc.gridwidth = 0;
        this.addLabeledComponentToGBL("Font Transform:", this.transformMenu, gbl, gbc, 20, this);
        gbc.gridwidth = 1;
        this.addLabeledComponentToGBL("Range: ", this.rm, gbl, gbc, 2, this);
        this.addLabeledComponentToGBL("Size: ", this.sizeField, gbl, gbc, 40, this);
        gbc.gridwidth = 0;
        this.addLabeledComponentToGBL("Graphics Transform: ", this.transformMenuG2, gbl, gbc, 20, this);
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        this.addLabeledComponentToGBL("Method: ", this.methodsMenu, gbl, gbc, 2, this);
        this.addLabeledComponentToGBL("", null, gbl, gbc, 40, this);
        gbc.anchor = 13;
        gbc.gridwidth = 0;
        this.addLabeledComponentToGBL("Text to use:", this.textMenu, gbl, gbc, 20, this);
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        this.addLabeledComponentToGBL("LCD contrast: ", this.contrastSlider, gbl, gbc, 2, this);
        gbc.gridwidth = 1;
        this.addLabeledComponentToGBL("Antialiasing: ", this.antiAliasMenu, gbl, gbc, 40, this);
        gbc.anchor = 13;
        gbc.gridwidth = 0;
        this.addLabeledComponentToGBL("Fractional metrics: ", this.fracMetricsMenu, gbl, gbc, 20, this);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 0, 0, 2);
        gbc.fill = 1;
        gbl.setConstraints(this.fp, gbc);
        this.add(this.fp);
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 2, 0, 0);
        gbl.setConstraints(this.statusBar, gbc);
        this.add(this.statusBar);
    }

    private void addLabeledComponentToGBL(String name, JComponent c, GridBagLayout gbl, GridBagConstraints gbc, int leftInset, Container target) {
        LabelV2 l = new LabelV2(this, name);
        l.setLabelFor(c);
        GridBagConstraints gbcLabel = (GridBagConstraints)gbc.clone();
        if (gbcLabel.gridwidth == 0) {
            gbcLabel.gridwidth = -1;
        }
        gbcLabel.insets = new Insets(2, leftInset, 2, 0);
        gbcLabel.gridwidth = 1;
        gbcLabel.weightx = 0.0;
        if (c == null) {
            c = new JLabel("");
        }
        gbcLabel.anchor = 13;
        gbl.setConstraints(l, gbcLabel);
        target.add(l);
        gbl.setConstraints(c, gbc);
        target.add(c);
    }

    private void setupMenu() {
        int i;
        JMenu fileMenu = new JMenu("File");
        JMenu optionMenu = new JMenu("Option");
        fileMenu.add(new MenuItemV2(this, "Save Selected Options...", this));
        fileMenu.add(new MenuItemV2(this, "Load Options...", this));
        fileMenu.addSeparator();
        fileMenu.add(new MenuItemV2(this, "Save as PNG...", this));
        fileMenu.add(new MenuItemV2(this, "Load PNG File to Compare...", this));
        fileMenu.add(new MenuItemV2(this, "Page Setup...", this));
        fileMenu.add(new MenuItemV2(this, "Print...", this));
        fileMenu.addSeparator();
        fileMenu.add(new MenuItemV2(this, "Exit", this));
        this.displayGridCBMI = new CheckboxMenuItemV2(this, "Display Grid", true, this);
        this.force16ColsCBMI = new CheckboxMenuItemV2(this, "Force 16 Columns", false, this);
        this.showFontInfoCBMI = new CheckboxMenuItemV2(this, "Display Font Info", false, this);
        optionMenu.add(this.displayGridCBMI);
        optionMenu.add(this.force16ColsCBMI);
        optionMenu.add(this.showFontInfoCBMI);
        optionMenu.addSeparator();
        this.familyAndStyleRBMI = new JRadioButtonMenuItem("Select font using Family Name and Style");
        this.familyAndStyleRBMI.addActionListener(this);
        this.familyAndSubFamilyRBMI = new JRadioButtonMenuItem("Select font using Family Name and SubFamily");
        this.familyAndSubFamilyRBMI.addActionListener(this);
        this.fontNameRBMI = new JRadioButtonMenuItem("Select font using Full Name");
        this.fontNameRBMI.addActionListener(this);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.familyAndStyleRBMI);
        bg.add(this.familyAndSubFamilyRBMI);
        bg.add(this.fontNameRBMI);
        this.familyAndStyleRBMI.setSelected(true);
        optionMenu.add(this.familyAndStyleRBMI);
        optionMenu.add(this.familyAndSubFamilyRBMI);
        optionMenu.add(this.fontNameRBMI);
        JMenuBar mb = this.parent.getJMenuBar();
        if (mb == null) {
            mb = new JMenuBar();
        }
        mb.add(fileMenu);
        mb.add(optionMenu);
        this.parent.setJMenuBar(mb);
        String[] fontList = Font2DTest.getAllFamilyNames();
        for (i = 0; i < fontList.length; ++i) {
            this.fontMenu.addItem(fontList[i]);
        }
        this.fontMenu.setSelectedItem("Dialog");
        fontList = Font2DTest.getAllFontNames();
        for (i = 0; i < fontList.length; ++i) {
            this.fontNameMenu.addItem(fontList[i]);
        }
        this.fontNameMenu.setSelectedItem("Dialog");
        this.styleMenu.addItem("Plain");
        this.styleMenu.addItem("Bold");
        this.styleMenu.addItem("Italic");
        this.styleMenu.addItem("Bold Italic");
        this.transformMenu.addItem("None");
        this.transformMenu.addItem("Scale");
        this.transformMenu.addItem("Shear");
        this.transformMenu.addItem("Rotate");
        this.transformMenuG2.addItem("None");
        this.transformMenuG2.addItem("Scale");
        this.transformMenuG2.addItem("Shear");
        this.transformMenuG2.addItem("Rotate");
        this.methodsMenu.addItem("drawString");
        this.methodsMenu.addItem("drawChars");
        this.methodsMenu.addItem("drawBytes");
        this.methodsMenu.addItem("drawGlyphVector");
        this.methodsMenu.addItem("TextLayout.draw");
        this.methodsMenu.addItem("GlyphVector.getOutline + draw");
        this.methodsMenu.addItem("TextLayout.getOutline + draw");
        this.textMenu.addItem("Unicode Range");
        this.textMenu.addItem("All Glyphs");
        this.textMenu.addItem("User Text");
        this.textMenu.addItem("Text File");
        this.textMenu.addActionListener(this);
    }

    private void setupDialog() {
        this.filePromptDialog = new JFileChooser();
        this.userTextDialog = new JDialog(this.parent, "User Text", false);
        JPanel dialogTopPanel = new JPanel();
        JPanel dialogBottomPanel = new JPanel();
        LabelV2 message1 = new LabelV2(this, "Enter text below and then press update");
        LabelV2 message2 = new LabelV2(this, "(Unicode char can be denoted by \\uXXXX)");
        LabelV2 message3 = new LabelV2(this, "(Supplementary chars can be denoted by \\UXXXXXX)");
        this.userTextArea = new JTextArea("Font2DTest!");
        ButtonV2 bUpdate = new ButtonV2(this, "Update", this);
        this.userTextArea.setFont(new Font("dialog", 0, 12));
        dialogTopPanel.setLayout(new GridLayout(3, 1));
        dialogTopPanel.add(message1);
        dialogTopPanel.add(message2);
        dialogTopPanel.add(message3);
        dialogBottomPanel.add(bUpdate);
        JScrollPane userTextAreaSP = new JScrollPane(this.userTextArea);
        userTextAreaSP.setPreferredSize(new Dimension(300, 100));
        this.userTextDialog.getContentPane().setLayout(new BorderLayout());
        this.userTextDialog.getContentPane().add("North", dialogTopPanel);
        this.userTextDialog.getContentPane().add("Center", userTextAreaSP);
        this.userTextDialog.getContentPane().add("South", dialogBottomPanel);
        this.userTextDialog.pack();
        this.userTextDialog.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ Font2DTest this$0;
            {
                Font2DTest font2DTest = this$0;
                Objects.requireNonNull(font2DTest);
                this.this$0 = font2DTest;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                this.this$0.userTextDialog.setVisible(false);
            }
        });
        this.printCBGroup = new ButtonGroup();
        Objects.requireNonNull(this.fp);
        this.printModeCBs[0] = new JRadioButton("Print one page from currently displayed character/line", true);
        Objects.requireNonNull(this.fp);
        this.printModeCBs[1] = new JRadioButton("Print all characters in currently selected range", false);
        Objects.requireNonNull(this.fp);
        this.printModeCBs[2] = new JRadioButton("Print all lines of text", false);
        LabelV2 l = new LabelV2(this, "Note: Page range in native \"Print\" dialog will not affect the result");
        JPanel buttonPanel = new JPanel();
        Objects.requireNonNull(this.fp);
        this.printModeCBs[2].setEnabled(false);
        buttonPanel.add(new ButtonV2(this, "Print", this));
        buttonPanel.add(new ButtonV2(this, "Cancel", this));
        this.printDialog = new JDialog(this.parent, "Print...", true);
        this.printDialog.setResizable(false);
        this.printDialog.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ Font2DTest this$0;
            {
                Font2DTest font2DTest = this$0;
                Objects.requireNonNull(font2DTest);
                this.this$0 = font2DTest;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                this.this$0.printDialog.setVisible(false);
            }
        });
        this.printDialog.getContentPane().setLayout(new GridLayout(this.printModeCBs.length + 2, 1));
        this.printDialog.getContentPane().add(l);
        for (int i = 0; i < this.printModeCBs.length; ++i) {
            this.printCBGroup.add(this.printModeCBs[i]);
            this.printDialog.getContentPane().add(this.printModeCBs[i]);
        }
        this.printDialog.getContentPane().add(buttonPanel);
        this.printDialog.pack();
        this.fontInfoDialog = new JDialog(this.parent, "Font info", false);
        this.fontInfoDialog.setResizable(false);
        this.fontInfoDialog.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ Font2DTest this$0;
            {
                Font2DTest font2DTest = this$0;
                Objects.requireNonNull(font2DTest);
                this.this$0 = font2DTest;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                this.this$0.fontInfoDialog.setVisible(false);
                this.this$0.showFontInfoCBMI.setState(false);
            }
        });
        JPanel fontInfoPanel = new JPanel();
        fontInfoPanel.setLayout(new GridLayout(this.fontInfos.length, 1));
        for (int i = 0; i < this.fontInfos.length; ++i) {
            this.fontInfos[i] = new LabelV2(this, "");
            fontInfoPanel.add(this.fontInfos[i]);
        }
        this.fontInfoDialog.getContentPane().add(fontInfoPanel);
        this.userTextDialog.setLocation(200, 300);
        this.fontInfoDialog.setLocation(0, 400);
    }

    public void fireRangeChanged() {
        int[] range = this.rm.getSelectedRange();
        Objects.requireNonNull(this.fp);
        this.fp.setTextToDraw(0, range, null, null);
        if (canDisplayCheck) {
            this.setupFontList(range[0], range[1]);
        }
        if (this.showFontInfoCBMI.getState()) {
            this.fireUpdateFontInfo();
        }
    }

    public void fireChangeStatus(String message, boolean error) {
        this.statusBar.setText(message);
        this.fp.showingError = error;
    }

    public void fireUpdateFontInfo() {
        if (this.showFontInfoCBMI.getState()) {
            String[] infos = this.fp.getFontInfo();
            for (int i = 0; i < this.fontInfos.length; ++i) {
                this.fontInfos[i].setText(infos[i]);
            }
            this.fontInfoDialog.pack();
        }
    }

    private void setupFontList(int rangeStart, int rangeEnd) {
        int listCount = this.fontMenu.getItemCount();
        int size = 16;
        try {
            size = Float.valueOf(this.sizeField.getText()).intValue();
        }
        catch (Exception e) {
            System.out.println("Invalid font size in the size textField. Using default value of 16");
        }
        int style = this.fontStyles[this.styleMenu.getSelectedIndex()];
        for (int i = 0; i < listCount; ++i) {
            String fontName = (String)this.fontMenu.getItemAt(i);
            Font f = new Font(fontName, style, size);
            if (this.rm.getSelectedIndex() != 91 && this.canDisplayRange(f, rangeStart, rangeEnd)) {
                this.fontMenu.setBit(i, true);
                continue;
            }
            this.fontMenu.setBit(i, false);
        }
        this.fontMenu.repaint();
    }

    protected boolean canDisplayRange(Font font, int rangeStart, int rangeEnd) {
        for (int i = rangeStart; i < rangeEnd; ++i) {
            if (!font.canDisplay(i)) continue;
            return true;
        }
        return false;
    }

    private String promptFile(boolean isSave, String initFileName) {
        File file;
        String fileName;
        int retVal;
        String str;
        if (this.filePromptDialog == null) {
            return null;
        }
        if (isSave) {
            this.filePromptDialog.setDialogType(1);
            this.filePromptDialog.setDialogTitle("Save...");
            str = "Save";
        } else {
            this.filePromptDialog.setDialogType(0);
            this.filePromptDialog.setDialogTitle("Load...");
            str = "Load";
        }
        if (initFileName != null) {
            this.filePromptDialog.setSelectedFile(new File(initFileName));
        }
        if ((retVal = this.filePromptDialog.showDialog(this, str)) == 0 && (fileName = (file = this.filePromptDialog.getSelectedFile()).getAbsolutePath()) != null) {
            return fileName;
        }
        return null;
    }

    private String[] parseUserText(String orig) {
        int length = orig.length();
        StringTokenizer perLine = new StringTokenizer(orig, "\n");
        String[] textLines = new String[perLine.countTokens()];
        int lineNumber = 0;
        while (perLine.hasMoreElements()) {
            StringBuffer converted = new StringBuffer();
            String oneLine = perLine.nextToken();
            int lineLength = oneLine.length();
            int prevEscapeEnd = 0;
            int nextEscape = -1;
            do {
                int nextBMPEscape = oneLine.indexOf("\\u", prevEscapeEnd);
                int nextSupEscape = oneLine.indexOf("\\U", prevEscapeEnd);
                int n = nextBMPEscape < 0 ? (nextSupEscape < 0 ? -1 : nextSupEscape) : (nextEscape = nextSupEscape < 0 ? nextBMPEscape : Math.min(nextBMPEscape, nextSupEscape));
                if (nextEscape == -1) continue;
                if (prevEscapeEnd < nextEscape) {
                    converted.append(oneLine.substring(prevEscapeEnd, nextEscape));
                }
                prevEscapeEnd = nextEscape + (nextEscape == nextBMPEscape ? 6 : 8);
                try {
                    String hex = oneLine.substring(nextEscape + 2, prevEscapeEnd);
                    if (nextEscape == nextBMPEscape) {
                        converted.append((char)Integer.parseInt(hex, 16));
                        continue;
                    }
                    converted.append(new String(Character.toChars(Integer.parseInt(hex, 16))));
                }
                catch (Exception e) {
                    int copyLimit = Math.min(lineLength, prevEscapeEnd);
                    converted.append(oneLine.substring(nextEscape, copyLimit));
                }
            } while (nextEscape != -1);
            if (prevEscapeEnd < lineLength) {
                converted.append(oneLine.substring(prevEscapeEnd, lineLength));
            }
            textLines[lineNumber++] = converted.toString();
        }
        return textLines;
    }

    private void readTextFile(String fileName) {
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fileName));
            int numBytes = bis.available();
            if (numBytes == 0) {
                throw new Exception("Text file " + fileName + " is empty");
            }
            byte[] byteData = new byte[numBytes];
            bis.read(byteData, 0, numBytes);
            bis.close();
            String fileText = numBytes >= 2 && (byteData[0] == -1 && byteData[1] == -2 || byteData[0] == -2 && byteData[1] == -1) ? new String(byteData, StandardCharsets.UTF_16) : new String(byteData);
            int length = fileText.length();
            StringTokenizer perLine = new StringTokenizer(fileText, "\n");
            for (int i = 0; i < length; ++i) {
                char iTh = fileText.charAt(i);
                if (iTh == '\r') {
                    if (i < length - 1 && fileText.charAt(i + 1) == '\n') {
                        perLine = new StringTokenizer(fileText, "\r\n");
                        break;
                    }
                    perLine = new StringTokenizer(fileText, "\r");
                    break;
                }
                if (iTh == '\n') break;
            }
            int lineNumber = 0;
            int numLines = perLine.countTokens();
            String[] textLines = new String[numLines];
            while (perLine.hasMoreElements()) {
                String oneLine = perLine.nextToken();
                if (oneLine == null) {
                    oneLine = " ";
                }
                textLines[lineNumber++] = oneLine;
            }
            this.fp.setTextToDraw(this.fp.FILE_TEXT, null, null, textLines);
            this.rm.setEnabled(false);
            this.methodsMenu.setEnabled(false);
        }
        catch (Exception ex) {
            this.fireChangeStatus("ERROR: Failed to Read Text File; See Stack Trace", true);
            ex.printStackTrace();
        }
    }

    private void writeCurrentOptions(String fileName) {
        try {
            String curOptions = this.fp.getCurrentOptions();
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(fileName));
            int[] range = this.rm.getSelectedRange();
            String completeOptions = "Font2DTest Option File\n" + this.displayGridCBMI.getState() + "\n" + this.force16ColsCBMI.getState() + "\n" + this.showFontInfoCBMI.getState() + "\n" + fontSelectionType + "\n" + (String)this.fontMenu.getSelectedItem() + "\n" + (String)this.fontNameMenu.getSelectedItem() + "\n" + (String)this.fontSubFamilyMenu.getSelectedItem() + "\n" + String.valueOf(this.rm.getSelectedItem()) + "\n" + range[0] + "\n" + range[1] + "\n" + curOptions + this.tFileName;
            byte[] toBeWritten = completeOptions.getBytes(StandardCharsets.UTF_16);
            bos.write(toBeWritten, 0, toBeWritten.length);
            bos.close();
        }
        catch (Exception ex) {
            this.fireChangeStatus("ERROR: Failed to Save Options File; See Stack Trace", true);
            ex.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateGUI() {
        selectedText = this.textMenu.getSelectedIndex();
        Objects.requireNonNull(this.fp);
        if (selectedText == 2) {
            this.userTextDialog.setVisible(true);
        } else {
            this.userTextDialog.setVisible(false);
        }
        Objects.requireNonNull(this.fp);
        this.printModeCBs[0].setSelected(true);
        if (selectedText == this.fp.FILE_TEXT) ** GOTO lbl-1000
        Objects.requireNonNull(this.fp);
        if (selectedText == 2) lbl-1000:
        // 2 sources

        {
            if (selectedText == this.fp.FILE_TEXT) {
                this.methodsMenu.setSelectedItem("TextLayout.draw");
            }
            Objects.requireNonNull(this.fp);
            this.methodsMenu.setEnabled(selectedText == 2);
            Objects.requireNonNull(this.fp);
            this.printModeCBs[1].setEnabled(false);
            Objects.requireNonNull(this.fp);
            this.printModeCBs[2].setEnabled(true);
        } else {
            Objects.requireNonNull(this.fp);
            if (selectedText == 1) {
                this.methodsMenu.setSelectedItem("drawGlyphVector");
            }
            Objects.requireNonNull(this.fp);
            this.methodsMenu.setEnabled(selectedText == 0);
            Objects.requireNonNull(this.fp);
            this.printModeCBs[1].setEnabled(true);
            Objects.requireNonNull(this.fp);
            this.printModeCBs[2].setEnabled(false);
        }
        Objects.requireNonNull(this.fp);
        if (selectedText == 0) {
            this.fontInfos[1].setVisible(true);
            this.rm.setEnabled(true);
        } else {
            this.fontInfos[1].setVisible(false);
            this.rm.setEnabled(false);
        }
    }

    private void loadOptions(String fileName) {
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fileName));
            int numBytes = bis.available();
            byte[] byteData = new byte[numBytes];
            bis.read(byteData, 0, numBytes);
            bis.close();
            if (numBytes < 2 || byteData[0] != -2 || byteData[1] != -1) {
                throw new Exception("Not a Font2DTest options file");
            }
            String options = new String(byteData, StandardCharsets.UTF_16);
            StringTokenizer perLine = new StringTokenizer(options, "\n");
            String title = perLine.nextToken();
            if (!title.equals("Font2DTest Option File")) {
                throw new Exception("Not a Font2DTest options file");
            }
            boolean displayGridOpt = Boolean.parseBoolean(perLine.nextToken());
            boolean force16ColsOpt = Boolean.parseBoolean(perLine.nextToken());
            boolean showFontInfoOpt = Boolean.parseBoolean(perLine.nextToken());
            int fontSelType = Integer.parseInt(perLine.nextToken());
            String fmItem = perLine.nextToken();
            String fnmItem = perLine.nextToken();
            String fsmItem = perLine.nextToken();
            String rangeNameOpt = perLine.nextToken();
            int rangeStartOpt = Integer.parseInt(perLine.nextToken());
            int rangeEndOpt = Integer.parseInt(perLine.nextToken());
            String fontNameOpt = perLine.nextToken();
            float fontSizeOpt = Float.parseFloat(perLine.nextToken());
            int fontStyleOpt = Integer.parseInt(perLine.nextToken());
            int fontTransformOpt = Integer.parseInt(perLine.nextToken());
            int g2TransformOpt = Integer.parseInt(perLine.nextToken());
            int textToUseOpt = Integer.parseInt(perLine.nextToken());
            int drawMethodOpt = Integer.parseInt(perLine.nextToken());
            int antialiasOpt = Integer.parseInt(perLine.nextToken());
            int fractionalOpt = Integer.parseInt(perLine.nextToken());
            int lcdContrast = Integer.parseInt(perLine.nextToken());
            String[] userTextOpt = new String[]{"Font2DTest!"};
            Object dialogEntry = "Font2DTest!";
            Objects.requireNonNull(this.fp);
            if (textToUseOpt == 2) {
                int numLines = perLine.countTokens();
                int lineNumber = 0;
                if (numLines != 0) {
                    userTextOpt = new String[numLines];
                    dialogEntry = "";
                    while (perLine.hasMoreElements()) {
                        userTextOpt[lineNumber] = perLine.nextToken();
                        dialogEntry = (String)dialogEntry + userTextOpt[lineNumber] + "\n";
                        ++lineNumber;
                    }
                }
            }
            this.displayGridCBMI.setState(displayGridOpt);
            this.force16ColsCBMI.setState(force16ColsOpt);
            this.showFontInfoCBMI.setState(showFontInfoOpt);
            this.rm.setSelectedRange(rangeNameOpt, rangeStartOpt, rangeEndOpt);
            this.currentFontName = fontNameOpt;
            this.setFontSelectionType(fontSelType);
            this.fontMenu.setSelectedItem(fmItem);
            this.fontNameMenu.setSelectedItem(fnmItem);
            this.fontSubFamilyMenu.setSelectedItem(fsmItem);
            this.sizeField.setText(String.valueOf(fontSizeOpt));
            this.styleMenu.setSelectedIndex(fontStyleOpt);
            this.transformMenu.setSelectedIndex(fontTransformOpt);
            this.transformMenuG2.setSelectedIndex(g2TransformOpt);
            this.textMenu.setSelectedIndex(textToUseOpt);
            this.methodsMenu.setSelectedIndex(drawMethodOpt);
            this.antiAliasMenu.setSelectedIndex(antialiasOpt);
            this.fracMetricsMenu.setSelectedIndex(fractionalOpt);
            this.contrastSlider.setValue(lcdContrast);
            this.userTextArea.setText((String)dialogEntry);
            this.updateGUI();
            if (textToUseOpt == this.fp.FILE_TEXT) {
                this.tFileName = perLine.nextToken();
                this.readTextFile(this.tFileName);
            }
            this.fp.loadOptions(displayGridOpt, force16ColsOpt, rangeStartOpt, rangeEndOpt, fontNameOpt, fontSizeOpt, fontStyleOpt, fontTransformOpt, g2TransformOpt, textToUseOpt, drawMethodOpt, antialiasOpt, fractionalOpt, lcdContrast, userTextOpt);
            if (showFontInfoOpt) {
                this.fireUpdateFontInfo();
                this.fontInfoDialog.setVisible(true);
            } else {
                this.fontInfoDialog.setVisible(false);
            }
        }
        catch (Exception ex) {
            this.fireChangeStatus("ERROR: Failed to Load Options File; See Stack Trace", true);
            ex.printStackTrace();
        }
    }

    private void loadComparisonPNG(String fileName) {
        try {
            BufferedImage image = ImageIO.read(new File(fileName));
            JFrame f = new JFrame("Comparison PNG");
            ImagePanel ip = new ImagePanel(this, image);
            f.setResizable(false);
            f.getContentPane().add(ip);
            f.addWindowListener(new WindowAdapter(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    ((JFrame)e.getSource()).dispose();
                }
            });
            f.pack();
            f.setVisible(true);
        }
        catch (Exception ex) {
            this.fireChangeStatus("ERROR: Failed to Load PNG File; See Stack Trace", true);
            ex.printStackTrace();
        }
    }

    void setUseFamilyAndStyle() {
        if (fontSelectionType == 1) {
            return;
        }
        this.fontMenuLabel.setText(FAMILY_LABEL_TEXT);
        this.fontMenuPanel.removeAll();
        this.fontMenuPanel.add(this.fontMenu);
        if (fontSelectionType == 3) {
            this.styleLabel.setText(STYLE_LABEL_TEXT);
            this.stylePanel.removeAll();
            this.stylePanel.add(this.styleMenu);
        }
        fontSelectionType = 1;
        if (!this.familyAndStyleRBMI.isSelected()) {
            this.familyAndStyleRBMI.setSelected(true);
        }
        this.styleMenu.setSelectedIndex(0);
        this.currentFontName = (String)this.fontMenu.getSelectedItem();
        this.fp.setFontParams(this.currentFontName, Float.parseFloat(this.sizeField.getText()), 0, this.transformMenu.getSelectedIndex());
        this.revalidate();
        this.repaint();
    }

    void setUseFontName() {
        if (fontSelectionType == 2) {
            return;
        }
        this.fontMenuLabel.setText(NAME_LABEL_TEXT);
        this.fontMenuPanel.removeAll();
        this.fontMenuPanel.add(this.fontNameMenu);
        if (fontSelectionType == 3) {
            this.styleLabel.setText(STYLE_LABEL_TEXT);
            this.stylePanel.removeAll();
            this.stylePanel.add(this.styleMenu);
        }
        fontSelectionType = 2;
        if (!this.fontNameRBMI.isSelected()) {
            this.fontNameRBMI.setSelected(true);
        }
        this.styleMenu.setSelectedIndex(0);
        this.currentFontName = (String)this.fontNameMenu.getSelectedItem();
        this.fp.setFontParams(this.currentFontName, Float.parseFloat(this.sizeField.getText()), 0, this.transformMenu.getSelectedIndex());
        this.revalidate();
        this.repaint();
    }

    void setUseFamilyAndSubFamily() {
        String subname;
        Font font;
        if (fontSelectionType == 3) {
            return;
        }
        this.fontMenuLabel.setText(FAMILY_LABEL_TEXT);
        this.fontMenuPanel.removeAll();
        this.fontMenuPanel.add(this.fontMenu);
        this.styleLabel.setText(SUBFAMILY_LABEL_TEXT);
        this.stylePanel.removeAll();
        this.styleMenu.setSelectedIndex(0);
        String family = (String)this.fontMenu.getSelectedItem();
        this.updateSubFamilyMenu(family);
        this.stylePanel.add(this.fontSubFamilyMenu);
        fontSelectionType = 3;
        if (!this.familyAndSubFamilyRBMI.isSelected()) {
            this.familyAndSubFamilyRBMI.setSelected(true);
        }
        this.currentFontName = (font = FontFamily.getFont(family, subname = (String)this.fontSubFamilyMenu.getSelectedItem())) != null ? font.getFontName(l) : family;
        this.fp.setFontParams(this.currentFontName, Float.parseFloat(this.sizeField.getText()), 0, this.transformMenu.getSelectedIndex());
        this.revalidate();
        this.repaint();
    }

    void setFontSelectionType(int fsType) {
        switch (fsType) {
            case 1: {
                this.setUseFamilyAndStyle();
                break;
            }
            case 2: {
                this.setUseFontName();
                break;
            }
            case 3: {
                this.setUseFamilyAndSubFamily();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JMenuItem) {
            JMenuItem mi = (JMenuItem)source;
            String itemName = mi.getText();
            if (source == this.familyAndStyleRBMI) {
                this.setUseFamilyAndStyle();
                return;
            }
            if (source == this.familyAndSubFamilyRBMI) {
                this.setUseFamilyAndSubFamily();
                return;
            }
            if (source == this.fontNameRBMI) {
                this.setUseFontName();
                return;
            }
            if (itemName.equals("Save Selected Options...")) {
                String fileName = this.promptFile(true, "options.txt");
                if (fileName == null) return;
                this.writeCurrentOptions(fileName);
                return;
            }
            if (itemName.equals("Load Options...")) {
                String fileName = this.promptFile(false, "options.txt");
                if (fileName == null) return;
                this.loadOptions(fileName);
                return;
            }
            if (itemName.equals("Save as PNG...")) {
                String fileName = this.promptFile(true, String.valueOf(this.fontMenu.getSelectedItem()) + ".png");
                if (fileName == null) return;
                this.fp.doSavePNG(fileName);
                return;
            }
            if (itemName.equals("Load PNG File to Compare...")) {
                String fileName = this.promptFile(false, null);
                if (fileName == null) return;
                this.loadComparisonPNG(fileName);
                return;
            }
            if (itemName.equals("Page Setup...")) {
                this.fp.doPageSetup();
                return;
            }
            if (itemName.equals("Print...")) {
                this.printDialog.setVisible(true);
                return;
            }
            if (itemName.equals("Close")) {
                this.parent.dispose();
                return;
            }
            if (!itemName.equals("Exit")) return;
            System.exit(0);
            return;
        }
        if (source instanceof JTextField) {
            JTextField tf = (JTextField)source;
            float sz = 12.0f;
            try {
                sz = Float.parseFloat(this.sizeField.getText());
                if (sz < 1.0f || sz > 120.0f) {
                    sz = 12.0f;
                    this.sizeField.setText("12");
                }
            }
            catch (Exception se) {
                this.sizeField.setText("12");
            }
            if (tf != this.sizeField) return;
            this.fp.setFontParams(this.currentFontName, sz, this.styleMenu.getSelectedIndex(), this.transformMenu.getSelectedIndex());
            return;
        }
        if (source instanceof JButton) {
            String itemName = ((JButton)source).getText();
            if (itemName.equals("Print")) {
                int i = 0;
                while (i < this.printModeCBs.length) {
                    if (this.printModeCBs[i].isSelected()) {
                        this.printDialog.setVisible(false);
                        this.fp.doPrint(i);
                    }
                    ++i;
                }
                return;
            }
            if (itemName.equals("Cancel")) {
                this.printDialog.setVisible(false);
                return;
            }
            if (!itemName.equals("Update")) return;
            Objects.requireNonNull(this.fp);
            this.fp.setTextToDraw(2, null, this.parseUserText(this.userTextArea.getText()), null);
            return;
        }
        if (!(source instanceof JComboBox)) return;
        JComboBox c = (JComboBox)source;
        if (c == this.fontMenu || c == this.fontNameMenu || c == this.fontSubFamilyMenu || c == this.styleMenu || c == this.transformMenu) {
            if (c == this.fontNameMenu) {
                this.currentFontName = (String)this.fontNameMenu.getSelectedItem();
            } else if (c == this.fontMenu && fontSelectionType == 1) {
                this.currentFontName = (String)this.fontMenu.getSelectedItem();
            } else if (c == this.fontMenu && fontSelectionType == 3) {
                family = (String)this.fontMenu.getSelectedItem();
                this.updateSubFamilyMenu(family);
                String subname = (String)this.fontSubFamilyMenu.getSelectedItem();
                Font font = FontFamily.getFont(family, subname);
                if (font == null) {
                    return;
                }
                this.currentFontName = font.getFontName(l);
            } else if (c == this.fontSubFamilyMenu) {
                String subname;
                if (this.fontSubFamilyMenu.getItemCount() == 0) {
                    return;
                }
                family = (String)this.fontMenu.getSelectedItem();
                Font font = FontFamily.getFont(family, subname = (String)this.fontSubFamilyMenu.getSelectedItem());
                if (font == null) {
                    return;
                }
                this.currentFontName = font.getFontName(l);
            }
            float sz = 12.0f;
            try {
                sz = Float.parseFloat(this.sizeField.getText());
                if (sz < 1.0f || sz > 120.0f) {
                    sz = 12.0f;
                    this.sizeField.setText("12");
                }
            }
            catch (Exception se) {
                this.sizeField.setText("12");
            }
            this.fp.setFontParams(this.currentFontName, sz, this.styleMenu.getSelectedIndex(), this.transformMenu.getSelectedIndex());
            return;
        }
        if (c == this.methodsMenu) {
            this.fp.setDrawMethod(this.methodsMenu.getSelectedIndex());
            return;
        }
        if (c == this.textMenu) {
            if (canDisplayCheck) {
                this.fireRangeChanged();
            }
            int selected = this.textMenu.getSelectedIndex();
            Objects.requireNonNull(this.fp);
            if (selected == 0) {
                Objects.requireNonNull(this.fp);
                this.fp.setTextToDraw(0, this.rm.getSelectedRange(), null, null);
            } else {
                Objects.requireNonNull(this.fp);
                if (selected == 2) {
                    Objects.requireNonNull(this.fp);
                    this.fp.setTextToDraw(2, null, this.parseUserText(this.userTextArea.getText()), null);
                } else if (selected == this.fp.FILE_TEXT) {
                    String fileName = this.promptFile(false, null);
                    if (fileName == null) {
                        c.setSelectedIndex(this.currentTextChoice);
                        return;
                    }
                    this.tFileName = fileName;
                    this.readTextFile(fileName);
                } else {
                    Objects.requireNonNull(this.fp);
                    if (selected == 1) {
                        Objects.requireNonNull(this.fp);
                        this.fp.setTextToDraw(1, null, null, null);
                    }
                }
            }
            this.updateGUI();
            this.currentTextChoice = selected;
            return;
        }
        if (c == this.transformMenuG2) {
            this.fp.setTransformG2(this.transformMenuG2.getSelectedIndex());
            return;
        }
        if (c != this.antiAliasMenu) {
            if (c != this.fracMetricsMenu) return;
        }
        if (c == this.antiAliasMenu) {
            boolean enabled = FontPanel.AAValues.isLCDMode(this.antiAliasMenu.getSelectedItem());
            this.contrastSlider.setEnabled(enabled);
        }
        this.fp.setRenderingHints(this.antiAliasMenu.getSelectedItem(), this.fracMetricsMenu.getSelectedItem(), this.contrastSlider.getValue());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source instanceof JSlider) {
            this.fp.setRenderingHints(this.antiAliasMenu.getSelectedItem(), this.fracMetricsMenu.getSelectedItem(), this.contrastSlider.getValue());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)source;
            if (cbmi == this.displayGridCBMI) {
                this.fp.setGridDisplay(this.displayGridCBMI.getState());
            } else if (cbmi == this.force16ColsCBMI) {
                this.fp.setForce16Columns(this.force16ColsCBMI.getState());
            } else if (cbmi == this.showFontInfoCBMI) {
                if (this.showFontInfoCBMI.getState()) {
                    this.fireUpdateFontInfo();
                    this.fontInfoDialog.setVisible(true);
                } else {
                    this.fontInfoDialog.setVisible(false);
                }
            }
        }
    }

    private static void printUsage() {
        String usage = "Usage: java -jar Font2DTest.jar [options]\n\nwhere options include:\n    -dcdc | -disablecandisplaycheck disable canDisplay check for font\n    -?    | -help                   print this help message\n\nExample :\n     To disable canDisplay check on font for ranges\n     java -jar Font2DTest.jar -dcdc";
        System.out.println(usage);
        System.exit(0);
    }

    private static void buildFontInfo() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        familyNames = ge.getAvailableFontFamilyNames();
        allFonts = ge.getAllFonts();
        allFontNames = new ArrayList<String>();
        Locale l = Locale.getDefault();
        for (Font f : allFonts) {
            allFontNames.add(f.getFontName(l));
            String family = f.getFamily(l);
            FontFamily ff = FontFamily.getFontFamily(family);
            if (ff == null) {
                ff = FontFamily.createFontFamily(family);
            }
            ff.add(f);
        }
    }

    String getFontNameFor(String family, String subFamily) {
        return family + " " + subFamily;
    }

    void updateSubFamilyMenu(String name) {
        FontFamily family = FontFamily.getFontFamily(name);
        this.fontSubFamilyMenu.removeAllItems();
        String[] sfNames = family.getSubFamilyNames();
        for (int i = 0; i < sfNames.length; ++i) {
            this.fontSubFamilyMenu.addItem(sfNames[i]);
        }
        this.fontSubFamilyMenu.setSelectedIndex(0);
    }

    static String[] getAllFontNames() {
        return (String[])allFontNames.stream().sorted().toArray(String[]::new);
    }

    static String[] getAllFamilyNames() {
        return familyNames;
    }

    public static void main(String[] argv) {
        if (argv.length > 0) {
            if (argv[0].equalsIgnoreCase("-disablecandisplaycheck") || argv[0].equalsIgnoreCase("-dcdc")) {
                canDisplayCheck = false;
            } else {
                Font2DTest.printUsage();
            }
        }
        Font2DTest.buildFontInfo();
        try {
            UIManager.setLookAndFeel(new NimbusLookAndFeel());
            SwingUtilities.invokeAndWait(() -> {
                JFrame f = new JFrame("Font2DTest");
                final Font2DTest f2dt = new Font2DTest(f);
                f.addWindowListener(new WindowAdapter(){

                    public void windowOpening(WindowEvent e) {
                        f2dt.repaint();
                    }

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                f.getContentPane().add(f2dt);
                f.pack();
                f.setVisible(true);
            });
        }
        catch (InterruptedException | InvocationTargetException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
    }

    static {
        familyMap = new HashMap<String, FontFamily>();
    }

    private final class LabelV2
    extends JLabel {
        final /* synthetic */ Font2DTest this$0;

        public LabelV2(Font2DTest font2DTest, String name) {
            Font2DTest font2DTest2 = font2DTest;
            Objects.requireNonNull(font2DTest2);
            this.this$0 = font2DTest2;
            super(name);
        }
    }

    private final class ChoiceV2
    extends JComboBox<String> {
        private BitSet bitSet;
        final /* synthetic */ Font2DTest this$0;

        public ChoiceV2(Font2DTest font2DTest) {
            Font2DTest font2DTest2 = font2DTest;
            Objects.requireNonNull(font2DTest2);
            this.this$0 = font2DTest2;
            this.bitSet = null;
        }

        public ChoiceV2(Font2DTest font2DTest, ActionListener al) {
            Font2DTest font2DTest2 = font2DTest;
            Objects.requireNonNull(font2DTest2);
            this.this$0 = font2DTest2;
            this.bitSet = null;
            this.addActionListener(al);
        }

        public ChoiceV2(Font2DTest font2DTest, ActionListener al, boolean fontChoice) {
            this(font2DTest, al);
            if (fontChoice) {
                this.setToolTipText("");
                this.bitSet = new BitSet();
                this.setRenderer(new ChoiceV2Renderer(font2DTest, this));
            }
        }

        @Override
        public String getToolTipText() {
            int index = this.getSelectedIndex();
            String fontName = (String)this.getSelectedItem();
            if (fontName != null) {
                int n = this.this$0.textMenu.getSelectedIndex();
                Objects.requireNonNull(this.this$0.fp);
                if (n == 0) {
                    if (this.getBit(index)) {
                        return "Font \"" + fontName + "\" can display some characters in \"" + String.valueOf(this.this$0.rm.getSelectedItem()) + "\" range";
                    }
                    return "Font \"" + fontName + "\" cannot display any characters in \"" + String.valueOf(this.this$0.rm.getSelectedItem()) + "\" range";
                }
            }
            return super.getToolTipText();
        }

        public void setBit(int bitIndex, boolean value) {
            this.bitSet.set(bitIndex, value);
        }

        public boolean getBit(int bitIndex) {
            return this.bitSet.get(bitIndex);
        }
    }

    private final class MenuItemV2
    extends JMenuItem {
        final /* synthetic */ Font2DTest this$0;

        public MenuItemV2(Font2DTest font2DTest, String name, ActionListener al) {
            Font2DTest font2DTest2 = font2DTest;
            Objects.requireNonNull(font2DTest2);
            this.this$0 = font2DTest2;
            super(name);
            this.addActionListener(al);
        }
    }

    private final class CheckboxMenuItemV2
    extends JCheckBoxMenuItem {
        final /* synthetic */ Font2DTest this$0;

        public CheckboxMenuItemV2(Font2DTest font2DTest, String name, boolean b, ItemListener il) {
            Font2DTest font2DTest2 = font2DTest;
            Objects.requireNonNull(font2DTest2);
            this.this$0 = font2DTest2;
            super(name, b);
            this.addItemListener(il);
        }
    }

    private final class ButtonV2
    extends JButton {
        final /* synthetic */ Font2DTest this$0;

        public ButtonV2(Font2DTest font2DTest, String name, ActionListener al) {
            Font2DTest font2DTest2 = font2DTest;
            Objects.requireNonNull(font2DTest2);
            this.this$0 = font2DTest2;
            super(name);
            this.addActionListener(al);
        }
    }

    private final class ImagePanel
    extends JPanel {
        private final BufferedImage bi;
        final /* synthetic */ Font2DTest this$0;

        public ImagePanel(Font2DTest font2DTest, BufferedImage image) {
            Font2DTest font2DTest2 = font2DTest;
            Objects.requireNonNull(font2DTest2);
            this.this$0 = font2DTest2;
            this.bi = image;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.bi.getWidth(), this.bi.getHeight());
        }

        @Override
        public void paintComponent(Graphics g) {
            g.drawImage(this.bi, 0, 0, this);
        }
    }

    static class FontFamily {
        static Map<String, FontFamily> familyMap = new HashMap<String, FontFamily>();
        private static Locale l = Locale.getDefault();
        private List<Font> fonts = new ArrayList<Font>();
        private List<String> subFamilyNames = new ArrayList<String>();
        private Map<String, Font> nameToFontMap = new HashMap<String, Font>();
        private String familyName;

        private FontFamily(String name) {
            this.familyName = name;
        }

        String stripFamily(String family, String fullName) {
            if (family.equals(fullName)) {
                return "";
            }
            char[] familyChars = family.toCharArray();
            char[] fullChars = fullName.toCharArray();
            int familyIndex = 0;
            int fullIndex = 0;
            while (familyIndex < familyChars.length && fullIndex < fullChars.length) {
                if (fullIndex == fullChars.length) {
                    System.err.println("WEIRD FONT " + family + " " + fullName);
                    break;
                }
                if (familyChars[familyIndex] == fullChars[fullIndex]) {
                    ++familyIndex;
                    ++fullIndex;
                    continue;
                }
                if (familyChars[familyIndex] == ' ' && fullChars[fullIndex] == '-') {
                    ++familyIndex;
                    ++fullIndex;
                    continue;
                }
                if (familyChars[familyIndex] == '-' && fullChars[fullIndex] == ' ') {
                    ++familyIndex;
                    ++fullIndex;
                    continue;
                }
                if (familyChars[familyIndex] == ' ' || familyChars[familyIndex] == '-') {
                    ++familyIndex;
                    continue;
                }
                if (fullChars[fullIndex] != ' ' && fullChars[fullIndex] != '-') break;
                ++fullIndex;
            }
            if (fullIndex == fullChars.length) {
                return fullName;
            }
            return fullName.substring(fullIndex);
        }

        void add(Font f) {
            String sfn;
            String fontName = f.getFontName(l);
            int flen = this.familyName.length();
            int nlen = fontName.length();
            if (fontName.equals(this.familyName)) {
                sfn = "Regular";
            } else {
                sfn = this.stripFamily(this.familyName, fontName);
                sfn = sfn.replace('-', ' ');
            }
            this.fonts.add(f);
            this.subFamilyNames.add(sfn);
            this.nameToFontMap.put(sfn, f);
        }

        String[] getSubFamilyNames() {
            return (String[])this.subFamilyNames.stream().sorted().toArray(String[]::new);
        }

        Font getFontForSubFamilyName(String name) {
            return this.nameToFontMap.get(name);
        }

        static FontFamily getFontFamily(String name) {
            return familyMap.get(name);
        }

        static FontFamily createFontFamily(String name) {
            FontFamily f = familyMap.get(name);
            if (f == null) {
                f = new FontFamily(name);
                familyMap.put(name, f);
            }
            return f;
        }

        static Font getFont(String familyName, String subFamilyName) {
            FontFamily family = FontFamily.getFontFamily(familyName);
            return family.getFontForSubFamilyName(subFamilyName);
        }
    }

    private final class ChoiceV2Renderer
    extends DefaultListCellRenderer {
        private ImageIcon yesImage;
        private ImageIcon blankImage;
        private ChoiceV2 choice;
        final /* synthetic */ Font2DTest this$0;

        public ChoiceV2Renderer(Font2DTest font2DTest, ChoiceV2 choice) {
            Font2DTest font2DTest2 = font2DTest;
            Objects.requireNonNull(font2DTest2);
            this.this$0 = font2DTest2;
            this.choice = null;
            BufferedImage yes = new BufferedImage(10, 10, 2);
            Graphics2D g = yes.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Color.BLUE);
            g.drawLine(0, 5, 3, 10);
            g.drawLine(1, 5, 4, 10);
            g.drawLine(3, 10, 10, 0);
            g.drawLine(4, 9, 9, 0);
            g.dispose();
            BufferedImage blank = new BufferedImage(10, 10, 2);
            this.yesImage = new ImageIcon(yes);
            this.blankImage = new ImageIcon(blank);
            this.choice = choice;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int n = this.this$0.textMenu.getSelectedIndex();
            Objects.requireNonNull(this.this$0.fp);
            if (n == 0) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (index == -1) {
                    index = this.choice.getSelectedIndex();
                }
                if (this.choice.getBit(index)) {
                    this.setIcon(this.yesImage);
                } else {
                    this.setIcon(this.blankImage);
                }
            } else {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                this.setIcon(this.blankImage);
            }
            return this;
        }
    }
}

