/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.ide.highlighter.XmlLikeFileType;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlElementFactoryImpl
extends XmlElementFactory {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(XmlElementFactoryImpl.class);

    public XmlElementFactoryImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public XmlTag createTagFromText(@NotNull @NonNls CharSequence text, @NotNull Language language) throws IncorrectOperationException {
        FileType type;
        XmlDocument document;
        XmlTag tag;
        if (text == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(0);
        }
        if (language == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(1);
        }
        if ((tag = (document = this.createXmlDocument(text, "dummy." + (type = XmlElementFactoryImpl.getFileType(language)).getDefaultExtension(), type)).getRootTag()) == null) {
            throw new IncorrectOperationException("Incorrect tag text");
        }
        XmlTag xmlTag = tag;
        if (xmlTag == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(2);
        }
        return xmlTag;
    }

    @NotNull
    public XmlTag createTagFromText(@NotNull CharSequence text) throws IncorrectOperationException {
        if (text == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(3);
        }
        XmlTag xmlTag = this.createTagFromText(text, (Language)XMLLanguage.INSTANCE);
        if (xmlTag == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(4);
        }
        return xmlTag;
    }

    @NotNull
    public XmlAttribute createXmlAttribute(@NotNull String name, @NotNull String value) throws IncorrectOperationException {
        if (name == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(5);
        }
        if (value == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(6);
        }
        return this.createAttribute(name, XmlElementFactoryImpl.quoteValue(value), (FileType)XmlFileType.INSTANCE);
    }

    @NotNull
    public XmlAttribute createAttribute(@NotNull @NonNls String name, @NotNull String value, @Nullable PsiElement context) throws IncorrectOperationException {
        if (name == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(7);
        }
        if (value == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(8);
        }
        return this.createAttribute(name, XmlElementFactoryImpl.quoteValue(value), XmlElementFactoryImpl.getFileType(context));
    }

    @NotNull
    public XmlAttribute createAttribute(@NotNull String name, @NotNull String value, @Nullable Character quoteStyle, @Nullable PsiElement context) throws IncorrectOperationException {
        if (name == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(9);
        }
        if (value == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(10);
        }
        return this.createAttribute(name, XmlElementFactoryImpl.quoteValue(value, quoteStyle), XmlElementFactoryImpl.getFileType(context));
    }

    @NotNull
    private XmlAttribute createAttribute(@NotNull String name, @NotNull String quotedValue, @NotNull FileType fileType) {
        if (name == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(11);
        }
        if (quotedValue == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(12);
        }
        if (fileType == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(13);
        }
        XmlDocument document = this.createXmlDocument("<tag " + name + "=" + quotedValue + "/>", "dummy." + fileType.getDefaultExtension(), fileType);
        XmlTag tag = document.getRootTag();
        assert (tag != null);
        XmlAttribute[] attributes = tag.getAttributes();
        LOG.assertTrue(attributes.length == 1, (Object)document.getText());
        XmlAttribute xmlAttribute = attributes[0];
        if (xmlAttribute == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(14);
        }
        return xmlAttribute;
    }

    @NotNull
    public static String quoteValue(@NotNull String value, @Nullable Character quoteStyle) {
        if (value == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(15);
        }
        if (quoteStyle != null) {
            if (quoteStyle.charValue() == '\'') {
                String string = quoteStyle + StringUtil.replace((String)value, (String)"'", (String)"&apos;") + quoteStyle;
                if (string == null) {
                    XmlElementFactoryImpl.$$$reportNull$$$0(16);
                }
                return string;
            }
            if (quoteStyle.charValue() == '\"') {
                String string = quoteStyle + StringUtil.replace((String)value, (String)"\"", (String)"&quot;") + quoteStyle;
                if (string == null) {
                    XmlElementFactoryImpl.$$$reportNull$$$0(17);
                }
                return string;
            }
        }
        return XmlElementFactoryImpl.quoteValue(value);
    }

    @NotNull
    public static String quoteValue(@NotNull String value) {
        char quoteChar;
        if (value == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(18);
        }
        if (!value.contains("\"")) {
            quoteChar = '\"';
        } else if (!value.contains("'")) {
            quoteChar = '\'';
        } else {
            quoteChar = '\"';
            value = StringUtil.replace((String)value, (String)"\"", (String)"&quot;");
        }
        String string = quoteChar + value + quoteChar;
        if (string == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public XmlText createDisplayText(@NotNull String s) throws IncorrectOperationException {
        XmlTag tagFromText;
        XmlText[] textElements;
        if (s == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(20);
        }
        if ((textElements = (tagFromText = this.createTagFromText("<a>" + XmlTagUtil.getCDATAQuote((String)s) + "</a>")).getValue().getTextElements()).length == 0) {
            XmlText xmlText = (XmlText)ASTFactory.composite((IElementType)XmlElementType.XML_TEXT);
            if (xmlText == null) {
                XmlElementFactoryImpl.$$$reportNull$$$0(21);
            }
            return xmlText;
        }
        XmlText xmlText = textElements[0];
        if (xmlText == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(22);
        }
        return xmlText;
    }

    @NotNull
    public XmlTag createXHTMLTagFromText(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(23);
        }
        XmlDocument document = this.createXmlDocument(text, "dummy.xhtml", (FileType)XHtmlFileType.INSTANCE);
        XmlTag tag = document.getRootTag();
        assert (tag != null) : "No tag created from: " + text;
        XmlTag xmlTag = tag;
        if (xmlTag == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(24);
        }
        return xmlTag;
    }

    @NotNull
    public XmlTag createHTMLTagFromText(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(25);
        }
        XmlDocument document = this.createXmlDocument(text, "dummy.html", (FileType)HtmlFileType.INSTANCE);
        XmlTag tag = document.getRootTag();
        assert (tag != null) : "No tag created from: " + text;
        XmlTag xmlTag = tag;
        if (xmlTag == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(26);
        }
        return xmlTag;
    }

    private XmlDocument createXmlDocument(@NonNls CharSequence text, @NonNls String fileName, FileType fileType) {
        XmlFile xmlFile;
        PsiFile fileFromText = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(fileName, fileType, text);
        if (fileFromText instanceof XmlFile) {
            xmlFile = (XmlFile)fileFromText;
        } else {
            xmlFile = (XmlFile)fileFromText.getViewProvider().getPsi(((LanguageFileType)fileType).getLanguage());
            assert (xmlFile != null);
        }
        XmlDocument document = xmlFile.getDocument();
        assert (document != null);
        return document;
    }

    @NotNull
    private static FileType getFileType(@Nullable PsiElement context) {
        if (context == null) {
            XmlFileType xmlFileType = XmlFileType.INSTANCE;
            if (xmlFileType == null) {
                XmlElementFactoryImpl.$$$reportNull$$$0(27);
            }
            return xmlFileType;
        }
        if (context.getLanguage().isKindOf((Language)HTMLLanguage.INSTANCE)) {
            FileType fileType = XmlElementFactoryImpl.getFileType(context.getLanguage());
            if (fileType == null) {
                XmlElementFactoryImpl.$$$reportNull$$$0(28);
            }
            return fileType;
        }
        XmlLikeFileType xmlLikeFileType = PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)false) instanceof HtmlTag ? HtmlFileType.INSTANCE : XmlFileType.INSTANCE;
        if (xmlLikeFileType == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(29);
        }
        return xmlLikeFileType;
    }

    private static FileType getFileType(@NotNull Language language) {
        if (language == null) {
            XmlElementFactoryImpl.$$$reportNull$$$0(30);
        }
        assert (language instanceof XMLLanguage) : "Tag can be created only for xml language";
        LanguageFileType type = language.getAssociatedFileType();
        return type == null ? XmlFileType.INSTANCE : type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 14, 16, 17, 19, 21, 22, 24, 26, 27, 28, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 4: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/XmlElementFactoryImpl";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotedValue";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/XmlElementFactoryImpl";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTagFromText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttribute";
                break;
            }
            case 16: 
            case 17: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "quoteValue";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createDisplayText";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createXHTMLTagFromText";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createHTMLTagFromText";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTagFromText";
                break;
            }
            case 2: 
            case 4: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createXmlAttribute";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createAttribute";
                break;
            }
            case 15: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "quoteValue";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createDisplayText";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createXHTMLTagFromText";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createHTMLTagFromText";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getFileType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 14, 16, 17, 19, 21, 22, 24, 26, 27, 28, 29 -> new IllegalStateException(string);
        };
    }
}

