/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.FeatureRestriction;
import ai.grazie.rules.common.WordSet;
import ai.grazie.rules.de.AdjDeclination;
import ai.grazie.rules.de.AgreementSet;
import ai.grazie.rules.de.Capitalization;
import ai.grazie.rules.de.Case;
import ai.grazie.rules.de.GermanDateChecker;
import ai.grazie.rules.de.GermanTreePatterns;
import ai.grazie.rules.de.GermanValences;
import ai.grazie.rules.de.PrepositionIssues;
import ai.grazie.rules.de.SemanticRules;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class Articles {
    static final String NO_ARTICLE_WITH_PROFESSIONS_MESSAGE = "Bei Berufsbezeichnungen wird normalerweise kein Artikel verwendet";
    static final String ARTICLE_AFTER_COPULA_MESSAGE = "In beschreibenden S\u00e4tzen wird normalerweise ein unbestimmter Artikel verwendet";
    static final String islandCountries = "Bahamas|Far(\u00f6|oe)ern?|Komoren|Malediven|Marshallinseln|Philippinen|Salomonen|Seychellen";
    private static final NodePattern oneWordCountryPlu = NodePattern.N.form("Bahamas|Far(\u00f6|oe)ern?|Komoren|Malediven|Marshallinseln|Philippinen|Salomonen|Seychellen|Niederlanden?|VAE|USA");
    static final NodePattern countryPluralArticle = NodePattern.or(oneWordCountryPlu, NodePattern.N.inFormSequence(2, "Vereinigten?", "Arabischen?", "Emiraten?"), NodePattern.N.inFormSequence(1, "Vereinigten?", "Staaten"), NodePattern.N.inFormSequence(1, "Kapverdischen", "Inseln"));
    private static final NodePattern oneWordCountryFem = NodePattern.N.form("Elfenbeink\u00fcste|Mongolei|Schweiz|Slowakei|T\u00fcrkei|Ukraine|Vatikanstadt");
    static final NodePattern countryFeminineArticle = NodePattern.or(oneWordCountryFem, NodePattern.N.inFormSequence(1, "Dominikanische|Tschechische|Zentralafrikanische", "Republik"), NodePattern.N.inFormSequence(1, "Demokratische", "Republik", "Kongo"));
    private static final NodePattern oneWordCountryMas = NodePattern.N.form("Irak|Jemen|Libanon|Oman|Senegal|Sudan|Tschad|Vatikan");
    static final NodePattern countryMasculineArticle = NodePattern.or(oneWordCountryMas, NodePattern.N.form("kongo").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("Republik"))));
    static final NodePattern countryNeutralNoArticle = NodePattern.or(NodePattern.N.form("Afghanistan|\u00c4gypten|Albanien|Algerien|Andorra|Angola|\u00c4quatorialguinea|Argentinien|Armenien|Aserbaidschan|\u00c4thiopien|Australien|Bahrain|Bangladesch|Barbados|Belarus|Belgien|Belize|Benin|Bhutan|Bolivien|Bosnien|Botsuana|Brasilien|Brunei|Bulgarien|Burundi|Cabo|Chile|China|D\u00e4nemark|Deutschland|Dominica|Dschibuti|Ecuador|England|Eritrea|Estland|Eswatini|Fidschi|Finnland|Frankreich|Gabun|Gambia|Georgien|Ghana|Grenada|Griechenland|Gr\u00f6nland|Gro\u00dfbritannien|Guatemala|Guinea|Guyana|Haiti|Honduras|Hongkong|Indien|Indonesien|Irland|Island|Israel|Italien|Jamaika|Japan|Jordanien|Kambodscha|Kamerun|Kanada|Kasachstan|Katar|Kenia|Kirgisistan|Kiribati|Kolumbien|Kroatien|Kuba|Kuwait|Laos|Lesotho|Lettland|Liberia|Libyen|Liechtenstein|Litauen|Luxemburg|Macau|Madagaskar|Malawi|Malaysia|Mali|Malta|Marokko|Mauretanien|Mauritius|Mexiko|Mikronesien|Moldau|Monaco|Montenegro|Mosambik|Myanmar|Namibia|Nauru|Nepal|Neuseeland|Nicaragua|Nigeria|Nordkorea|Nordmazedonien|Norwegen|\u00d6sterreich|Pakistan|Pal\u00e4stina|Palau|Panama|Paraguay|Peru|Portugal|Puerto|Ruanda|Rum\u00e4nien|Russland|Sambia|Samoa|Schottland|Schweden|Serbien|Sierra|Simbabwe|Singapur|Slowenien|Somalia|Spanien|S\u00fcdafrika|S\u00fcdkorea|Suriname|Syrien|Tadschikistan|Taiwan|Tansania|Thailand|Tibet|Togo|Tonga|Trinidad|Tschechien|Tunesien|Turkmenistan|Tuvalu|Uganda|Ungarn|Uruguay|Usbekistan|Vanuatu|Venezuela|Vietnam|Wales|Zypern"), NodePattern.N.inFormSequence(0, "Saudi", "-", "Arabien"), NodePattern.N.form("Polen").noPos(".*PLU.*"));
    static final NodePattern zBEnd = NodePattern.N.inFormSequence(3, "z", "\\.", "B", "\\.");
    static final WordSet abstractNouns = WordSet.loadResource("de/abstract_nouns.txt");

    static String getDefArticleForm(Node node, Case caze, AgreementSet.Number number, AgreementSet.Gender gender) {
        List<String> synth = node.tree().treeSupport().synthesize("der", "der", "ART:DEF:NOM:SIN:MAS", "ART:DEF:" + caze.name() + ":" + String.valueOf((Object)number) + ":" + gender.name());
        return synth.isEmpty() ? null : synth.get(0);
    }

    private static NodePattern pattern() {
        return NodePattern.or(Articles.noArticleWithProfessions(), Articles.articleAfterCopula(), Articles.fusedPrepositionConfusion(), Articles.countriesWithOrWithoutArticle(), Articles.articleWithSuperlative(), Articles.noArticleWithAbstractNouns(), Articles.doubleDet());
    }

    private static NodePattern doubleDet() {
        return NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").withDependent("de[pt]", NodePattern.N.pos("ART:DEF.*").withNextSibling(NodePattern.N.pos("PRO:POS.*")).correct(NodeCorrector.replace(""))).andNot(NodePattern.N.withDependent("acl", NodePattern.N.withDependent("obj", GermanTreePatterns.firstInPhraseAfterCommasOrConj.pos("ART:DEF.*")))).message("\u00dcberfl\u00fcssiger Artikel?");
    }

    @NotNull
    private static Node findArticlePos(Node node) {
        if (zBEnd.matches(node.prevNode())) {
            return node;
        }
        for (Node dep : node.allDependents()) {
            if (dep.isAfter(node)) break;
            if (dep.headRelation().matches("a(dv)?mod")) {
                return dep;
            }
            if (!dep.headRelation().equals("case")) continue;
            return dep.neighbor(1);
        }
        return node;
    }

    private static NodePattern countriesWithOrWithoutArticle() {
        NodePattern looksLikeNom = NodePattern.ROOT.noDependents("cop");
        NodePattern looksLikeAcc = NodePattern.N.withDependent("case", NodePattern.N.form("nach")).withHead(PrepositionIssues.goToHead);
        NodePattern setCorrectArticlePrepositionCase = NodePattern.custom((country, match) -> {
            AgreementSet.Number number;
            FeatureRestriction possibleCases = looksLikeNom.matches(country) ? FeatureRestriction.restricted((Node)country, (Enum[])new Case[]{Case.NOM}) : (looksLikeAcc.matches(country) ? FeatureRestriction.restricted((Node)country, (Enum[])new Case[]{Case.AKK}) : AgreementSet.calcPossibleCases(country));
            AgreementSet.Number number2 = number = countryPluralArticle.matches(country) ? AgreementSet.Number.PLU : AgreementSet.Number.SIN;
            AgreementSet.Gender gender = countryFeminineArticle.matches(country) ? AgreementSet.Gender.FEM : (countryMasculineArticle.matches(country) ? AgreementSet.Gender.MAS : AgreementSet.Gender.NEU);
            Node articleAnchor = Articles.findArticlePos(country);
            boolean hasPOS = NodePattern.N.anyPos().matches(country);
            Node inPrep = match.findMarkedNode("InPrep");
            ArrayList<NodeCorrector> correctors = new ArrayList<NodeCorrector>();
            for (Case caze : possibleCases.allowed()) {
                NodeCorrector corrector;
                String article = Articles.getDefArticleForm(country, caze, number, gender);
                if (article == null) {
                    return match;
                }
                NodeCorrector nodeCorrector = corrector = inPrep != null && article.equals("dem") ? NodeCorrector.replace(inPrep, "im") : NodeCorrector.insertBefore(articleAnchor, article + " ");
                if (hasPOS && number == AgreementSet.Number.PLU) {
                    corrector = corrector.join(NodeCorrector.inflect(country, "SUB:(.*):(SIN|PLU):(.*)", "SUB:" + caze.name() + ":PLU:$3"));
                }
                if (hasPOS && article.equals("des")) {
                    corrector = corrector.join(NodeCorrector.inflect(country, "SUB:(.*):(SIN|PLU):(.*)", "SUB:GEN:SIN:$3"));
                }
                for (Node adj : country.findDependents("amod")) {
                    AgreementSet.InflectedForm form = new AgreementSet.InflectedForm(gender, number, caze, AdjDeclination.DEF, AgreementSet.Person.P3);
                    corrector = corrector.join(form.inflect(adj, false, null));
                }
                correctors.add(corrector);
            }
            NodeCorrector resultCorrector = (NodeCorrector)StreamEx.of(correctors).reduce(NodeCorrector::or).orElseThrow();
            Node inNachPrepChangeToAuf = match.findMarkedNode("InNachPrepChangeToAuf");
            Node nachPrepChangeToIn = match.findMarkedNode("NachPrepChangeToIn");
            if (nachPrepChangeToIn != null) {
                resultCorrector = resultCorrector.join(NodeCorrector.replace(nachPrepChangeToIn, "in"));
            }
            if (inNachPrepChangeToAuf != null) {
                resultCorrector = resultCorrector.join(NodeCorrector.replace(inNachPrepChangeToAuf, "auf"));
            }
            return match.withCorrector(resultCorrector).withReportedNode(articleAnchor);
        });
        return NodePattern.or(NodePattern.or(NodePattern.N.pos("ART.*").correct(NodeCorrector.replace("")), AdjDeclination.anyFusedPreposition.and((prep, match) -> match.withCorrector(NodeCorrector.replace(prep, GermanValences.normalizePreposition(prep))))).withHead("det|case", countryNeutralNoArticle.markAs("Country").andOr(NodePattern.N.inFormSequence(0, "Saudi", "-", "Arabien"), NodePattern.N.noDependents("flat", NodePattern.N.afterHead())).noDependents("amod").noHeadRelation("conj|appos|flat.*|compound").andNot(NodePattern.N.form("Ungarn").withDependent("det", NodePattern.N.form("d(er|ie)")))).reportEverythingTouched().message("Der Name dieses Landes wird ohne Artikel verwendet, wenn es ohne Adjektiv im Text steht"), NodePattern.or(countryNeutralNoArticle.includeIntoReport().withDependent("amod", NodePattern.N.beforeHead().noPos("ADV.*").includeIntoReport().markAs("Adj")).noDependents("case", NodePattern.N.after("Adj")).message("Der Name dieses Landes wird mit Artikel verwendet, wenn es mit Adjektiv im Text steht"), NodePattern.or(countryPluralArticle, countryFeminineArticle.noDependents(".*", NodePattern.N.afterHead()), countryMasculineArticle.noDependents(".*", NodePattern.N.afterHead())).andNot(GermanTreePatterns.headInQuotes).reportEverythingTouched().message("Der Name dieses Landes wird normalerweise mit Artikel verwendet")).noDependents("det").andNot(NodePattern.N.withDependent("case", AdjDeclination.anyFusedPreposition)).andOr(NodePattern.N.withHead("conj", NodePattern.N.withDependent("case")), NodePattern.N.noHeadRelation("conj|appos|flat.*|compound")).andNot(NodePattern.N.withHeadRelation("nmod").beforeHead()).andNot(NodePattern.N.noSpaceBefore()).andOptionally(NodePattern.N.withDependent("case", NodePattern.N.form("in").markAs("InPrep"))).andOptionally(PrepositionIssues.needAufWithIslandCountry).andOptionally(NodePattern.N.noForm(islandCountries).withDependent("case", NodePattern.N.form("nach").markAs("NachPrepChangeToIn"))).and(setCorrectArticlePrepositionCase));
    }

    private static NodePattern fusedPrepositionConfusion() {
        NodePattern withArticle = NodePattern.N.withDependent("det", CommonPatterns.lowercasedHasPos("ART.*"));
        NodePattern geo = NodePattern.N.label("GEO_POLITICAL_ENTITY");
        NodePattern countryOneWordOrWithDependent = NodePattern.or(oneWordCountryFem, oneWordCountryMas, oneWordCountryPlu, NodePattern.N.withDependent("[an]mod|appos|flat"));
        return NodePattern.or(AdjDeclination.anyFusedPreposition.withHeadRelation("case").includeIntoReport().directlyBefore(NodePattern.or(NodePattern.or(NodePattern.N.pos("ART:DEF.*"), NodePattern.or(NodePattern.N.form("eine[mr]"), NodePattern.N.form("eine").andNot(NodePattern.N.directlyAfter(NodePattern.N.form(".*s")))).andOptionally(NodePattern.or(NodePattern.N.form("einem").withHead("det", NodePattern.N.pos(".*(MAS|NEU).*")), NodePattern.N.form("einer").withHead("det", NodePattern.N.pos(".*FEM.*")), NodePattern.not(NodePattern.N.withHeadRelation("det"))).correct(NodeCorrector.replace("einen")))).message("Unerwartete verschmolzene Pr\u00e4position vor einem Artikel"), NodePattern.N.pos("PRO:POS:.*").message("Unerwartete verschmolzene Pr\u00e4position vor einem Possessivpronomen"), NodePattern.N.pos("PRO:DEM:.*").message("Unerwartete verschmolzene Pr\u00e4position vor einem Demonstrativpronomen"), NodePattern.N.pos("PRO:PER:.*").withHeadRelation("obl").message("Unerwartete verschmolzene Pr\u00e4position vor einem Personalpronomen")).markAs("NextNode").includeIntoReport()).withHead(NodePattern.or(NodePattern.N.alreadyMarkedAs("NextNode"), NodePattern.N.withDependent("det.*", NodePattern.N.alreadyMarkedAs("NextNode")))).andOptionally(NodePattern.not(NodePattern.N.inFormSequence(0, "zum", "einem").before(Capitalization.zumAnderen)).and((prep, match) -> match.withCorrector(NodeCorrector.replace(prep, GermanValences.normalizePreposition(prep))))), NodePattern.or(NodePattern.N.form("in").directlyBefore(NodePattern.or(NodePattern.N.form("Begriffe?|Einsatz|Haus|Garten|Park|Preis").andOr(NodePattern.N.withDependent("cop"), NodePattern.N.withHead("obl", NodePattern.N.lemma("sein"))), NodePattern.N.form("Nullkommani(chts|x)|Nu|Gegenteil"), NodePattern.N.form("Vergleich|Laufe|Sinne|Falle|Rahmen").withDependent("nmod", NodePattern.N.afterHead()), GermanDateChecker.INSTANCE.longOrShortMonthName.noLabel(".*"), NodePattern.N.form("Auge").withHead("obl", NodePattern.N.lemma("behalten"))).markAs("Word")).correct(NodeCorrector.replace("im")), NodePattern.N.form("zu").withHead(NodePattern.or(NodePattern.N.form("gen\u00fcge").withHead(NodePattern.N.pos("VER.*")), NodePattern.N.form("neige").withHead(NodePattern.N.lemma("leeren|gehen")), NodePattern.N.form("verf\u00fcgung").withHead(NodePattern.N.lemma("stellen|stehen|haben")), NodePattern.N.form("vernunft").withHead(NodePattern.N.lemma("gelangen|kommen|bringen")), NodePattern.N.form("schule|arbeit").withHead(NodePattern.N.lemma("gehen")), NodePattern.N.form("wehr").withHead("obl", NodePattern.N.lemma("setzen"))).noDependents("det.*").markAs("Word")).correct(NodeCorrector.replace("zur")), NodePattern.N.form("an").beforeHead().withHead("case", SemanticRules.dayOfWeek.onlyPos(".*SIN.*").noDependents("det.*").markAs("Word")).correct(NodeCorrector.replace("am")), NodePattern.N.form("bei").directlyBefore(NodePattern.N.pos("SUB:DAT:SIN:NEU:INF").noPos("SUB.*PLU.*").noDependents(NodePattern.N.afterHead()).markAs("Word")).correct(NodeCorrector.replace("beim"))).message("\u201e$Word\u201c wird normalerweise mit einem bestimmten Artikel verwendet"), NodePattern.N.form("bei").directlyBefore(NodePattern.N.form("m")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "beim")).message("\u201eBeim\u201c wird zusammengeschrieben"), NodePattern.N.form("im").withHead("case", NodePattern.N.form("anbetracht").message("\u201e$_\u201c wird normalerweise mit einem unbestimmten Artikel verwendet")).correct(NodeCorrector.replace("in")), NodePattern.or(AdjDeclination.datFusedPreposition.markAs("Dat"), AdjDeclination.accFusedPreposition).noForm("zur").withHead("case", NodePattern.N.onlyPos(".*SIN:FEM.*").markAs("Head").noDependents("appos|flat").noDependents("conj", NodePattern.N.withDependent("appos|flat")).noForm("Mitte|TeamCity").andNot(NodePattern.N.noSpaceAfter().directlyBefore(NodePattern.or(CommonPatterns.colon.directlyBefore(CommonPatterns.withNumberLikeForm), CommonPatterns.HYPHEN_LIKE_NODE))).andNot(NodePattern.N.withHeadRelation("amod").pos(".*SUP.*")).andNot(NodePattern.N.form("Uhr").withDependent("nummod", NodePattern.N.form("([01]\\d|2[0123])(\\.|[:.,-]([012345][05]|59))")))).and((node, match) -> {
            Node head = match.getMarkedNode("Head");
            String replacement = GermanValences.normalizePreposition(node);
            NodeCorrector toPlainPreposition = NodeCorrector.replace(node, replacement);
            NodeCorrector toPrepWithArticle = NodeCorrector.replace(node, replacement + (match.findMarkedNode("Dat") != null ? " der" : " die"));
            if (withArticle.matches(head)) {
                return match.withCorrector(toPlainPreposition);
            }
            if (geo.matches(head)) {
                if (countryOneWordOrWithDependent.matches(head)) {
                    return match.withCorrector(toPrepWithArticle);
                }
                return match.withCorrector(toPlainPreposition);
            }
            return match.withCorrector(toPlainPreposition).withCorrector(toPrepWithArticle);
        }).message("Unerwartete verschmolzene Pr\u00e4position vor einem Femininum")).withHead(NodePattern.not(CommonPatterns.lowercasedHasPos("VER:1:SIN:KJ1:NON:NEB")));
    }

    static NodePattern noArticleWithProfessions() {
        return NodePattern.N.pos("SUB:NOM:SIN:.*").and(SemanticRules.job).includeIntoReport().noDependents("acl|[an]mod").withDependent("det", NodePattern.N.pos("ART:IND.*").includeIntoReport().correct(NodeCorrector.replace(""))).noDependents("nsubj|expl", NodePattern.N.form("das|es")).andOr(NodePattern.N.withDependent("cop"), NodePattern.N.withDependent("case", NodePattern.N.form("als")).withHead("obl", NodePattern.N.lemma("arbeiten")), NodePattern.N.withHead(NodePattern.N.lemma("werden"))).message(NO_ARTICLE_WITH_PROFESSIONS_MESSAGE);
    }

    static NodePattern articleAfterCopula() {
        NodePattern setExpression = NodePattern.or(NodePattern.N.inFormSequence(1, "kalter", "Kaffee"), NodePattern.N.inFormSequence(1, "h\u00f6chste", "Zeit"), NodePattern.N.inFormSequence(1, "tiefe", "Nacht"));
        return NodePattern.N.pos("SUB:NOM:SIN.*").withDependent("amod", NodePattern.N.pos("ADJ:NOM:SIN.*").noPos(".*:SUP:.*").noForm("((aller)?ers|zwei|drit|vier|f(\u00fc|ue)nf|sechs|sieben|ach|neun|zehn|elf|zw(\u00f6|oe)lf)t.*").markAs("NPadj")).withDependent("cop", NodePattern.N.pos("VER:.*SIN.*").lemma("sein").markAs("Cop")).withDependent("nsubj|expl", NodePattern.N.form("das|es")).noDependents("csubj|compound|flat|appos|det.*").noDependents("nmod", NodePattern.or(NodePattern.N.form("kein.*").beforeHead(), NodePattern.N.before("NPadj").after("Cop"))).noDependents("case", NodePattern.N.beforeHead()).noDependents("acl", NodePattern.N.withPhraseStart(CommonPatterns.skipForward(NodePattern.PUNCT, NodePattern.N.lemma("der")))).noForm(".*[hk]eit").andNot(SemanticRules.job).andNot(setExpression).includeIntoReport().message(ARTICLE_AFTER_COPULA_MESSAGE).and((noun, match) -> {
            Node npStart = match.getMarkedNode("NPadj").phraseStart();
            String article = noun.hasPos(".*FEM.*") ? "eine" : "ein";
            return match.withCorrector(NodeCorrector.insertBefore(npStart, article + " ")).withReportedNodes(npStart, noun);
        });
    }

    private static NodePattern addArticleAndFixAgreement() {
        return NodePattern.custom((node, match) -> {
            AgreementSet.Gender gender;
            Node anchor = match.getMarkedNode("Sup");
            AgreementSet headSet = AgreementSet.create(node);
            if (headSet == null) {
                return null;
            }
            String message = "Mit \u201e" + anchor.form() + "\u201c muss der bestimmte Artikel verwendet werden";
            AgreementSet.Gender gender2 = node.hasPos(".*MAS.*") ? AgreementSet.Gender.MAS : (gender = node.hasPos(".*FEM.*") ? AgreementSet.Gender.FEM : AgreementSet.Gender.NEU);
            AgreementSet.Number number = headSet.numberRestriction != null ? headSet.numberRestriction : (node.lowForm().equals("das") ? AgreementSet.Number.SIN : (node.hasPos(".*PLU.*") ? AgreementSet.Number.PLU : AgreementSet.Number.SIN));
            ArrayList<NodeCorrector> correctors = new ArrayList<NodeCorrector>();
            for (Case caze : headSet.possibleCases.allowed()) {
                String article = Articles.getDefArticleForm(node, caze, number, gender);
                if (article == null) {
                    return match.withMessage(message);
                }
                AgreementSet.InflectedForm defAgreementForm = new AgreementSet.InflectedForm(gender, number, caze, AdjDeclination.DEF, AgreementSet.Person.P3);
                NodeCorrector resultCorrector = NodeCorrector.insertBefore(anchor, article + " ");
                NodeCorrector fixAgreementInSet = NodeCorrector.joinAll(headSet.imposeFeatures(defAgreementForm, true).values());
                if (anchor.hasDependent("cop") && !anchor.form().endsWith("e")) {
                    resultCorrector = resultCorrector.join(NodeCorrector.regexReplace(anchor, "(.*ste)(.*)", "$1"));
                }
                if (fixAgreementInSet != null) {
                    resultCorrector = resultCorrector.join(fixAgreementInSet);
                }
                correctors.add(resultCorrector);
            }
            return match.withCorrectors(correctors).withMessage(message);
        });
    }

    private static NodePattern articleWithSuperlative() {
        return NodePattern.or(NodePattern.or(NodePattern.N.lemma("meist"), NodePattern.N.form("wenigst(e[nrms]?)?")).noDependents().markAs("Sup").withHead("amod", NodePattern.N.pos("SUB.*").noDependents("det(:poss)?|cop").noDependents("case", AdjDeclination.anyFusedPreposition).and(Articles.addArticleAndFixAgreement())), NodePattern.N.pos(".*SUP.*").markAs("Sup").withDependent("cop").noDependents("case|advmod", NodePattern.N.form("am").directlyBeforeHead()).noDependents("det(:poss)?").andNot(NodePattern.N.directlyAfter(NodePattern.N.pos("ART:DEF.*"))).withDependent("nsubj", Articles.addArticleAndFixAgreement()));
    }

    private static NodePattern noArticleWithAbstractNouns() {
        return Articles.abstractNouns.lemmaPattern.withDependent("det", NodePattern.N.pos("ART:IND.*").directlyBeforeHead().correct(NodeCorrector.replace(""))).andOr(NodePattern.N.withDependent("case", NodePattern.N.form("gegen")), NodePattern.N.withHead("ob[jl]", NodePattern.N.lemma("haben|bekommen|leiden"))).andNot(NodePattern.N.directlyBefore(CommonPatterns.comma).withDependent("acl|ccomp")).message("Bei abstrakten oder nicht z\u00e4hlbaren Substantiven wird kein unbestimmter Artikel verwendet");
    }

    static Rule.PatternRule rule() {
        return new Rule.PatternRule("Grammar.ARTICLE_ISSUES", "Falsche Verwendung oder Weglassen eines Artikels", "Der bestimmte Artikel \u201eder, die, das\u201c kennzeichnet eine bestimmte Person oder Sache, der unbestimmte Artikel \u201eein, eine\u201c eine unbestimmte, w\u00e4hrend der Nullartikel f\u00fcr generelle Aussagen oder f\u00fcr Massen- und Pluralbegriffe verwendet wird.", "https://deutschegrammatik20.de/das-substantiv-nomen/artikel-gebrauch/", () -> Articles.pattern(), new Example("Sie ist <b>eine \u00c4rztin</b>.", "Sie ist <b>\u00c4rztin</b>."), new Example("Ich denke, das ist <b>interessante Stadt</b>.", "Ich denke, das ist <b>eine interessante Stadt</b>."));
    }
}

