/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.DaemonAnalyzerTestCase;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.JavaExpectedHighlightingData;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.FileTreeAccessFilter;
import com.intellij.testFramework.HighlightTestInfo;
import com.intellij.testFramework.LightJavaCodeInsightTestCase;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.ArrayUtilRt;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class LightDaemonAnalyzerTestCase
extends LightJavaCodeInsightTestCase {
    private final FileTreeAccessFilter myJavaFilesFilter = new FileTreeAccessFilter();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ((DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.getProject())).prepareForTest();
        DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(false);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(true);
            DaemonCodeAnalyzerImpl daemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.getProject());
            if (daemonCodeAnalyzer != null) {
                daemonCodeAnalyzer.cleanupAfterTest();
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected void doTest(@NonNls String filePath, boolean checkWarnings, boolean checkInfos) {
        this.configureByFile(filePath);
        this.doTestConfiguredFile(checkWarnings, checkInfos, filePath);
    }

    protected void doTest(@NonNls String filePath, boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos) {
        this.configureByFile(filePath);
        this.doTestConfiguredFile(checkWarnings, checkWeakWarnings, checkInfos, filePath);
    }

    protected void doTestConfiguredFile(boolean checkWarnings, boolean checkInfos, @Nullable String filePath) {
        this.doTestConfiguredFile(checkWarnings, false, checkInfos, filePath);
    }

    protected void doTestConfiguredFile(boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos, @Nullable String filePath) {
        PsiManagerEx.getInstanceEx((Project)this.getProject()).setAssertOnFileLoadingFilter(VirtualFileFilter.NONE, this.getTestRootDisposable());
        ExpectedHighlightingData data = this.getExpectedHighlightingData(checkWarnings, checkWeakWarnings, checkInfos);
        this.checkHighlighting(data, this.composeLocalPath(filePath));
    }

    protected ExpectedHighlightingData getExpectedHighlightingData(boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos) {
        return new ExpectedHighlightingData(this.getEditor().getDocument(), checkWarnings, checkWeakWarnings, checkInfos);
    }

    @Nullable
    private String composeLocalPath(@Nullable String filePath) {
        return filePath != null ? this.getTestDataPath() + "/" + filePath : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHighlighting(@NotNull ExpectedHighlightingData data, String filePath) {
        if (data == null) {
            LightDaemonAnalyzerTestCase.$$$reportNull$$$0(0);
        }
        data.init();
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        this.getFile().getText();
        this.myJavaFilesFilter.allowTreeAccessForFile(this.getVFile());
        PsiManagerEx.getInstanceEx((Project)this.getProject()).setAssertOnFileLoadingFilter((VirtualFileFilter)this.myJavaFilesFilter, this.getTestRootDisposable());
        try {
            List<HighlightInfo> infos = this.doHighlighting();
            data.checkResult(this.getFile(), infos, this.getEditor().getDocument().getText(), filePath);
        }
        finally {
            PsiManagerEx.getInstanceEx((Project)this.getProject()).setAssertOnFileLoadingFilter(VirtualFileFilter.NONE, this.getTestRootDisposable());
        }
    }

    protected HighlightTestInfo doTestFile(@NonNls @NotNull String filePath) {
        if (filePath == null) {
            LightDaemonAnalyzerTestCase.$$$reportNull$$$0(1);
        }
        return new HighlightTestInfo(this.getTestRootDisposable(), new String[]{filePath}){

            @Override
            public HighlightTestInfo doTest() {
                String path = UsefulTestCase.assertOneElement(this.filePaths);
                LightDaemonAnalyzerTestCase.this.configureByFile(path);
                JavaExpectedHighlightingData data = new JavaExpectedHighlightingData(LightDaemonAnalyzerTestCase.this.getEditor().getDocument(), this.checkWarnings, this.checkWeakWarnings, this.checkInfos);
                if (this.checkSymbolNames) {
                    data.checkSymbolNames();
                }
                LightDaemonAnalyzerTestCase.this.checkHighlighting(data, LightDaemonAnalyzerTestCase.this.composeLocalPath(path));
                return this;
            }
        };
    }

    @NotNull
    protected @Unmodifiable List<HighlightInfo> highlightErrors() {
        List<HighlightInfo> list = this.doHighlighting(HighlightSeverity.ERROR);
        if (list == null) {
            LightDaemonAnalyzerTestCase.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    protected @Unmodifiable List<HighlightInfo> doHighlighting() {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        IntArrayList toIgnoreList = new IntArrayList();
        if (!this.doFolding()) {
            toIgnoreList.add(1);
        }
        if (!this.doInspections()) {
            toIgnoreList.add(7);
        }
        int[] toIgnore = toIgnoreList.isEmpty() ? ArrayUtilRt.EMPTY_INT_ARRAY : toIgnoreList.toIntArray();
        Editor editor2 = this.getEditor();
        PsiFile file = this.getFile();
        if (editor2 instanceof EditorWindow) {
            editor2 = ((EditorWindow)editor2).getDelegate();
            file = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file);
        }
        List<HighlightInfo> list = CodeInsightTestFixtureImpl.instantiateAndRun(file, editor2, toIgnore, this.canChangeDocumentDuringHighlighting());
        if (list == null) {
            LightDaemonAnalyzerTestCase.$$$reportNull$$$0(3);
        }
        return list;
    }

    private boolean canChangeDocumentDuringHighlighting() {
        return this.annotatedWith(DaemonAnalyzerTestCase.CanChangeDocumentDuringHighlighting.class);
    }

    protected @Unmodifiable List<HighlightInfo> doHighlighting(HighlightSeverity minSeverity) {
        return DaemonAnalyzerTestCase.filter(this.doHighlighting(), minSeverity);
    }

    protected boolean doFolding() {
        return false;
    }

    protected boolean doInspections() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/LightDaemonAnalyzerTestCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/LightDaemonAnalyzerTestCase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "highlightErrors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doHighlighting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkHighlighting";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doTestFile";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

