/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import tim.prune.data.FileType;
import tim.prune.data.SourceInfo;

public class FileInfo {
    private final ArrayList<SourceInfo> _sources = new ArrayList();
    private SourceInfo _previousSource = null;

    public void addSource(SourceInfo sourceInfo) {
        if (sourceInfo != null && sourceInfo != this._previousSource) {
            this._previousSource = sourceInfo;
            for (SourceInfo sourceInfo2 : this._sources) {
                if (sourceInfo2 != sourceInfo) continue;
                return;
            }
            this._sources.add(sourceInfo);
        }
    }

    public int getNumFiles() {
        return this._sources.size();
    }

    public String getFilename() {
        if (this.getNumFiles() == 1) {
            return this._sources.get(0).getName();
        }
        return "";
    }

    public SourceInfo getSource(int n) {
        return this._sources.get(n);
    }

    public List<String> getAllTitles() {
        return this.getAllValues(sourceInfo -> sourceInfo.getFileTitle());
    }

    public List<String> getAllDescriptions() {
        return this.getAllValues(sourceInfo -> sourceInfo.getFileDescription());
    }

    public List<String> getAllValues(ValueTaker valueTaker) {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        for (SourceInfo sourceInfo : this._sources) {
            String string = valueTaker.takeValue(sourceInfo);
            if (string == null || string.isEmpty() || hashSet.contains(string)) continue;
            arrayList.add(string);
            hashSet.add(string);
        }
        return arrayList;
    }

    public boolean hasExtensions(FileType fileType) {
        for (SourceInfo sourceInfo : this._sources) {
            String string;
            if (sourceInfo.getFileType() != fileType || (string = sourceInfo.getExtensions()) == null || string.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public List<String> getVersions(FileType fileType) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SourceInfo sourceInfo : this._sources) {
            String string;
            if (sourceInfo.getFileType() != fileType || (string = sourceInfo.getFileVersion()) == null || string.isEmpty()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private static interface ValueTaker {
        public String takeValue(SourceInfo var1);
    }
}

