/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.correlate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.cmd.PointAndMedia;
import tim.prune.config.TimezoneHelper;
import tim.prune.correlate.CardStack;
import tim.prune.correlate.MediaPreviewTableModel;
import tim.prune.correlate.MediaPreviewTableRow;
import tim.prune.correlate.MediaSelectionTableModel;
import tim.prune.correlate.MediaSelectionTableRow;
import tim.prune.correlate.OptionsChangedListener;
import tim.prune.correlate.PointMediaPair;
import tim.prune.correlate.TimeIndexPair;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.Field;
import tim.prune.data.MediaList;
import tim.prune.data.MediaObject;
import tim.prune.data.TimeDifference;
import tim.prune.data.Timestamp;
import tim.prune.data.Track;
import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.Describer;

public abstract class Correlator
extends GenericFunction {
    protected JDialog _dialog;
    private CardStack _cards = null;
    private JTable _selectionTable = null;
    protected JTable _previewTable = null;
    private boolean _previewEnabled = false;
    private boolean[] _cardEnabled = null;
    private TimeZone _timezone = null;
    private JTextField _offsetHourBox = null;
    private JTextField _offsetMinBox = null;
    private JTextField _offsetSecBox = null;
    private JRadioButton _mediaLaterOption = null;
    private JRadioButton _pointLaterOption = null;
    private JRadioButton _timeLimitRadio = null;
    private JRadioButton _distLimitRadio = null;
    private JTextField _limitMinBox = null;
    private JTextField _limitSecBox = null;
    private JTextField _limitDistBox = null;
    private JComboBox<String> _distUnitsDropdown = null;
    private JButton _nextButton = null;
    private JButton _backButton = null;
    protected JButton _okButton = null;

    public Correlator(App app) {
        super(app);
    }

    protected abstract String getMediaTypeKey();

    protected abstract MediaList<?> getMediaList();

    @Override
    public void begin() {
        if (!this._app.getTrackInfo().getTrack().hasData(Field.TIMESTAMP)) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("dialog.correlate.notimestamps"), this.getName(), 1);
            return;
        }
        if (!this.getMediaList().hasUncorrelatedMedia()) {
            Object[] objectArray = new Object[]{I18nManager.getText("button.continue"), I18nManager.getText("button.cancel")};
            if (JOptionPane.showOptionDialog(this._parentFrame, I18nManager.getText("dialog.correlate.nouncorrelated" + this.getMediaTypeKey() + "s"), this.getName(), 0, 2, null, objectArray, objectArray[1]) == 1) {
                return;
            }
        }
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, this.getName(), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeDialogContents());
            this._dialog.pack();
        }
        this._okButton.setEnabled(false);
        this._timezone = TimezoneHelper.getSelectedTimezone(this.getConfig());
        int n = 0;
        this._cardEnabled = null;
        while (!this.isCardEnabled(n)) {
            ++n;
        }
        this._cards.showCard(n);
        this.showCard(0);
        if (!this.isCardEnabled(1)) {
            this._app.showTip(4);
        }
        this._dialog.setVisible(true);
    }

    private JPanel makeDialogContents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._cards = new CardStack();
        JPanel jPanel2 = this.makeFirstPanel();
        if (jPanel2 == null) {
            jPanel2 = new JPanel();
        }
        this._cards.addCard(jPanel2);
        this._cards.addCard(this.makeSecondPanel());
        this._cards.addCard(this.makeThirdPanel());
        jPanel.add((Component)this._cards, "Center");
        JPanel jPanel3 = new JPanel();
        this._backButton = new JButton(I18nManager.getText("button.back"));
        this._backButton.addActionListener(actionEvent -> this.showCard(-1));
        this._backButton.setEnabled(false);
        jPanel3.add(this._backButton);
        this._nextButton = new JButton(I18nManager.getText("button.next"));
        this._nextButton.addActionListener(actionEvent -> this.showCard(1));
        jPanel3.add(this._nextButton);
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(actionEvent -> {
            this.finishCorrelation();
            this._dialog.dispose();
        });
        this._okButton.setEnabled(false);
        jPanel3.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    protected MediaSelectionTableModel makeSelectionTableModel() {
        MediaList<?> mediaList = this.getMediaList();
        MediaSelectionTableModel mediaSelectionTableModel = new MediaSelectionTableModel("dialog.correlate.select." + this.getMediaTypeKey() + "name", "dialog.correlate.select." + this.getMediaTypeKey() + "later", this.getTimezone());
        int n = mediaList.getCount();
        int n2 = 0;
        while (n2 < n) {
            Object obj = mediaList.get(n2);
            if (((MediaObject)obj).getDataPoint() != null && ((MediaObject)obj).getDataPoint().hasTimestamp() && ((MediaObject)obj).getOriginalStatus() == MediaObject.Status.NOT_CONNECTED) {
                long l = this.getMediaTimestamp((MediaObject)obj).getSecondsSince(((MediaObject)obj).getDataPoint().getTimestamp(), this._timezone);
                mediaSelectionTableModel.addMedia((MediaObject)obj, l);
            }
            ++n2;
        }
        return mediaSelectionTableModel;
    }

    protected static void groupRadioButtons(JRadioButton jRadioButton, JRadioButton jRadioButton2) {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        jRadioButton.setSelected(true);
    }

    protected static int getValue(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    protected static int getMedianIndex(MediaSelectionTableModel mediaSelectionTableModel) {
        Object object;
        TreeSet<TimeIndexPair> treeSet = new TreeSet<TimeIndexPair>();
        int n = mediaSelectionTableModel.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            object = mediaSelectionTableModel.getRow(n2);
            treeSet.add(new TimeIndexPair(((MediaSelectionTableRow)object).getTimeDiff().getTotalSeconds(), n2));
            ++n2;
        }
        TimeIndexPair timeIndexPair = null;
        object = treeSet.iterator();
        int n3 = 0;
        while (n3 < (n + 1) / 2) {
            timeIndexPair = (TimeIndexPair)object.next();
            ++n3;
        }
        return timeIndexPair.getIndex();
    }

    public void disableOkButton() {
        if (this._okButton != null) {
            this._okButton.setEnabled(false);
        }
    }

    protected JPanel makeFirstPanel() {
        return null;
    }

    private JPanel makeSecondPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(10, 10));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.correlate." + this.getMediaTypeKey() + "select.intro"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        jPanel.add((Component)jLabel, "North");
        this._selectionTable = new JTable();
        JScrollPane jScrollPane = new JScrollPane(this._selectionTable);
        jScrollPane.setPreferredSize(new Dimension(400, 100));
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel makeThirdPanel() {
        OptionsChangedListener optionsChangedListener = new OptionsChangedListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.correlate.options.intro"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(8, 6, 5, 6));
        jPanel2.add(jLabel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(I18nManager.getText("dialog.correlate.options.offsetpanel")));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout());
        jPanel4.setBorder(null);
        jPanel4.add(new JLabel(String.valueOf(I18nManager.getText("dialog.correlate.options.offset")) + ": "));
        this._offsetHourBox = new JTextField(3);
        this._offsetHourBox.addKeyListener(optionsChangedListener);
        jPanel4.add(this._offsetHourBox);
        jPanel4.add(new JLabel(I18nManager.getText("dialog.correlate.options.offset.hours")));
        this._offsetMinBox = new JTextField(3);
        this._offsetMinBox.addKeyListener(optionsChangedListener);
        jPanel4.add(this._offsetMinBox);
        jPanel4.add(new JLabel(I18nManager.getText("dialog.correlate.options.offset.minutes")));
        this._offsetSecBox = new JTextField(3);
        this._offsetSecBox.addKeyListener(optionsChangedListener);
        jPanel4.add(this._offsetSecBox);
        jPanel4.add(new JLabel(I18nManager.getText("dialog.correlate.options.offset.seconds")));
        jPanel3.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout());
        jPanel5.setBorder(null);
        this._mediaLaterOption = new JRadioButton(I18nManager.getText("dialog.correlate.options." + this.getMediaTypeKey() + "later"));
        this._pointLaterOption = new JRadioButton(I18nManager.getText("dialog.correlate.options.pointlater" + this.getMediaTypeKey()));
        this._mediaLaterOption.addItemListener(optionsChangedListener);
        this._pointLaterOption.addItemListener(optionsChangedListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._mediaLaterOption);
        buttonGroup.add(this._pointLaterOption);
        jPanel5.add(this._mediaLaterOption);
        jPanel5.add(this._pointLaterOption);
        jPanel3.add(jPanel5);
        jPanel3.setAlignmentX(0.0f);
        jPanel2.add(jPanel3);
        ActionListener actionListener = actionEvent -> this.enableEditBoxes();
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createTitledBorder(I18nManager.getText("dialog.correlate.options.limitspanel")));
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout());
        JRadioButton jRadioButton = new JRadioButton(I18nManager.getText("dialog.correlate.options.notimelimit"));
        jRadioButton.addItemListener(optionsChangedListener);
        jRadioButton.addActionListener(actionListener);
        jPanel7.add(jRadioButton);
        this._timeLimitRadio = new JRadioButton(String.valueOf(I18nManager.getText("dialog.correlate.options.timelimit")) + ": ");
        this._timeLimitRadio.addItemListener(optionsChangedListener);
        this._timeLimitRadio.addActionListener(actionListener);
        jPanel7.add(this._timeLimitRadio);
        Correlator.groupRadioButtons(jRadioButton, this._timeLimitRadio);
        this._limitMinBox = new JTextField(3);
        this._limitMinBox.addKeyListener(optionsChangedListener);
        jPanel7.add(this._limitMinBox);
        jPanel7.add(new JLabel(I18nManager.getText("dialog.correlate.options.offset.minutes")));
        this._limitSecBox = new JTextField(3);
        this._limitSecBox.addKeyListener(optionsChangedListener);
        jPanel7.add(this._limitSecBox);
        jPanel7.add(new JLabel(I18nManager.getText("dialog.correlate.options.offset.seconds")));
        jPanel6.add(jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout());
        JRadioButton jRadioButton2 = new JRadioButton(I18nManager.getText("dialog.correlate.options.nodistancelimit"));
        jRadioButton2.addItemListener(optionsChangedListener);
        jRadioButton2.addActionListener(actionListener);
        jPanel8.add(jRadioButton2);
        this._distLimitRadio = new JRadioButton(String.valueOf(I18nManager.getText("dialog.correlate.options.distancelimit")) + ": ");
        this._distLimitRadio.addItemListener(optionsChangedListener);
        this._distLimitRadio.addActionListener(actionListener);
        jPanel8.add(this._distLimitRadio);
        Correlator.groupRadioButtons(jRadioButton2, this._distLimitRadio);
        this._limitDistBox = new JTextField(4);
        this._limitDistBox.addKeyListener(optionsChangedListener);
        jPanel8.add(this._limitDistBox);
        String[] stringArray = new String[]{I18nManager.getText("units.kilometres"), I18nManager.getText("units.metres"), I18nManager.getText("units.miles")};
        this._distUnitsDropdown = new JComboBox<String>(stringArray);
        this._distUnitsDropdown.addItemListener(optionsChangedListener);
        jPanel8.add(this._distUnitsDropdown);
        jPanel6.add(jPanel8);
        jPanel6.setAlignmentX(0.0f);
        jPanel2.add(jPanel6);
        JButton jButton = new JButton(I18nManager.getText("button.preview"));
        jButton.addActionListener(actionEvent -> this.createPreview(true));
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "North");
        this._previewTable = new JTable(new MediaPreviewTableModel("dialog.correlate.select." + this.getMediaTypeKey() + "name", this.getTimezone()));
        JScrollPane jScrollPane = new JScrollPane(this._previewTable);
        jScrollPane.setPreferredSize(new Dimension(300, 100));
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    protected TimeZone getTimezone() {
        return TimezoneHelper.getSelectedTimezone(this.getConfig());
    }

    private void showCard(int n) {
        int n2 = this._cards.getCurrentCardIndex();
        int n3 = n2 + n;
        if (!this.isCardEnabled(n3)) {
            n3 += n;
        }
        this.setupCard(n3);
        this._backButton.setEnabled(n3 > 0 && (this.isCardEnabled(n3 - 1) || this.isCardEnabled(n3 - 2)));
        this._nextButton.setEnabled(n3 < this._cards.getNumCards() - 1);
        this._cards.showCard(n3);
    }

    private boolean isCardEnabled(int n) {
        if (this._cardEnabled == null) {
            this._cardEnabled = this.getCardEnabledFlags();
        }
        return n >= 0 && n < this._cardEnabled.length && this._cardEnabled[n];
    }

    protected boolean[] getCardEnabledFlags() {
        boolean[] blArray = new boolean[3];
        blArray[1] = this.makeSelectionTableModel().getRowCount() > 0;
        blArray[2] = true;
        return blArray;
    }

    protected void setupCard(int n) {
        this._previewEnabled = false;
        if (n == 1) {
            MediaSelectionTableModel mediaSelectionTableModel = this.makeSelectionTableModel();
            this._selectionTable.setModel(mediaSelectionTableModel);
            int n2 = 0;
            while (n2 < mediaSelectionTableModel.getColumnCount()) {
                this._selectionTable.getColumnModel().getColumn(n2).setPreferredWidth(n2 == 3 ? 50 : 150);
                ++n2;
            }
            n2 = mediaSelectionTableModel.getRowCount() < 3 ? 0 : Correlator.getMedianIndex(mediaSelectionTableModel);
            this._selectionTable.getSelectionModel().setSelectionInterval(n2, n2);
            this._nextButton.requestFocus();
        } else if (n == 2) {
            TimeDifference timeDifference = null;
            if (this.isCardEnabled(1)) {
                int n3 = this._selectionTable.getSelectedRow();
                if (n3 < 0) {
                    n3 = 0;
                }
                MediaSelectionTableRow mediaSelectionTableRow = ((MediaSelectionTableModel)this._selectionTable.getModel()).getRow(n3);
                timeDifference = mediaSelectionTableRow.getTimeDiff();
            }
            this.setupPreviewCard(timeDifference, (MediaObject)this.getMediaList().get(0));
        }
        this._okButton.setEnabled(n == 2 && ((MediaPreviewTableModel)this._previewTable.getModel()).hasAnySelected());
    }

    private void enableEditBoxes() {
        this._limitDistBox.setEnabled(this._distLimitRadio.isSelected());
        this._limitMinBox.setEnabled(this._timeLimitRadio.isSelected());
        this._limitSecBox.setEnabled(this._timeLimitRadio.isSelected());
    }

    protected TimeDifference parseTimeLimit() {
        if (!this._timeLimitRadio.isSelected()) {
            return null;
        }
        int n = Correlator.getValue(this._limitMinBox.getText());
        this._limitMinBox.setText("" + n);
        int n2 = Correlator.getValue(this._limitSecBox.getText());
        this._limitSecBox.setText("" + n2);
        if (n <= 0 && n2 <= 0) {
            return null;
        }
        return new TimeDifference(0, n, n2, true);
    }

    protected double parseDistanceLimit() {
        double d = -1.0;
        if (this._distLimitRadio.isSelected()) {
            try {
                d = Double.parseDouble(this._limitDistBox.getText());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (d <= 0.0) {
            this._limitDistBox.setText("0");
            return -1.0;
        }
        this._limitDistBox.setText("" + d);
        return Distance.convertDistanceToRadians(d, this.getSelectedDistanceUnits());
    }

    protected Unit getSelectedDistanceUnits() {
        Unit[] unitArray = new Unit[]{UnitSetLibrary.UNITS_KILOMETRES, UnitSetLibrary.UNITS_METRES, UnitSetLibrary.UNITS_MILES};
        return unitArray[this._distUnitsDropdown.getSelectedIndex()];
    }

    public void createPreview(boolean bl) {
        if (!this._previewEnabled) {
            return;
        }
        int n = Correlator.getValue(this._offsetHourBox.getText());
        int n2 = Correlator.getValue(this._offsetMinBox.getText());
        int n3 = Correlator.getValue(this._offsetSecBox.getText());
        boolean bl2 = this._mediaLaterOption.isSelected();
        this.createPreview(new TimeDifference(n, n2, n3, bl2), bl);
    }

    protected void setupPreviewCard(TimeDifference timeDifference, MediaObject mediaObject) {
        this._previewEnabled = false;
        TimeDifference timeDifference2 = timeDifference;
        if (timeDifference2 == null) {
            timeDifference2 = new TimeDifference(0L);
        }
        this._offsetHourBox.setText("" + timeDifference2.getNumHours());
        this._offsetMinBox.setText("" + timeDifference2.getNumMinutes());
        this._offsetSecBox.setText("" + timeDifference2.getNumSeconds());
        this._mediaLaterOption.setSelected(timeDifference2.getIsPositive());
        this._pointLaterOption.setSelected(!timeDifference2.getIsPositive());
        this._previewEnabled = true;
        this.enableEditBoxes();
        this.createPreview(timeDifference2, true);
    }

    protected abstract void createPreview(TimeDifference var1, boolean var2);

    protected Timestamp getMediaTimestamp(MediaObject mediaObject) {
        return mediaObject.getTimestamp();
    }

    protected PointMediaPair getPointPairForMedia(Track track, MediaObject mediaObject, TimeDifference timeDifference) {
        PointMediaPair pointMediaPair = new PointMediaPair(mediaObject);
        if (mediaObject.hasTimestamp()) {
            Timestamp timestamp = this.getMediaTimestamp(mediaObject);
            int n = track.getNumPoints();
            int n2 = 0;
            while (n2 < n) {
                Timestamp timestamp2;
                DataPoint dataPoint = track.getPoint(n2);
                if (dataPoint.getPhoto() == null && dataPoint.getAudio() == null && (timestamp2 = dataPoint.getTimestamp()) != null && timestamp2.isValid()) {
                    long l = timestamp2.getSecondsSince(timestamp, this._timezone) + timeDifference.getTotalSeconds();
                    pointMediaPair.addPoint(dataPoint, l);
                }
                ++n2;
            }
        }
        return pointMediaPair;
    }

    protected abstract void finishCorrelation();

    protected PointMediaPair[] getPointPairs() {
        MediaPreviewTableModel mediaPreviewTableModel = (MediaPreviewTableModel)this._previewTable.getModel();
        int n = mediaPreviewTableModel.getRowCount();
        PointMediaPair[] pointMediaPairArray = new PointMediaPair[n];
        int n2 = 0;
        while (n2 < n) {
            MediaPreviewTableRow mediaPreviewTableRow = mediaPreviewTableModel.getRow(n2);
            if (mediaPreviewTableRow.getCorrelateFlag()) {
                pointMediaPairArray[n2] = mediaPreviewTableRow.getPointPair();
            }
            ++n2;
        }
        return pointMediaPairArray;
    }

    protected String makeUndoText(int n) {
        Describer describer = new Describer("undo.correlate" + this.getMediaTypeKey(), "undo.correlate" + this.getMediaTypeKey() + "s");
        return describer.getDescriptionWithCount(n);
    }

    protected String makeConfirmText(int n) {
        Describer describer = new Describer("confirm.correlate" + this.getMediaTypeKey() + "s.single", "confirm.correlate" + this.getMediaTypeKey() + "s.multi");
        return describer.getDescriptionWithCount(n);
    }

    protected static boolean pointAlreadyBeingConnected(DataPoint dataPoint, List<PointAndMedia> list) {
        for (PointAndMedia pointAndMedia : list) {
            if (pointAndMedia.getPoint() != dataPoint) continue;
            return true;
        }
        return false;
    }
}

