/*!
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Common construct and functions used by both Log and LogSync
 */
import { Entry } from '../entry';
import { google } from '../../protos/protos';
export interface WriteOptions {
    labels?: {
        [index: string]: string;
    };
    resource?: MonitoredResource;
}
export type MonitoredResource = google.api.IMonitoredResource;
export declare enum Severity {
    emergency = 0,
    alert = 1,
    critical = 2,
    error = 3,
    warning = 4,
    notice = 5,
    info = 6,
    debug = 7
}
export type SeverityNames = keyof typeof Severity;
export type LogSeverityFunctions = {
    [P in SeverityNames]: Function;
};
/**
 * snakecaseKeys turns label keys from camel case to snake case.
 * @param labels
 */
export declare function snakecaseKeys(labels: {
    [p: string]: string;
} | null | undefined): {
    [p: string]: string;
} | null | undefined;
/**
 * Return an array of log entries with the desired severity assigned.
 *
 * @private
 *
 * @param {object|object[]} entries - Log entries.
 * @param {string} severity - The desired severity level.
 */
export declare function assignSeverityToEntries(entries: Entry | Entry[], severity: string): Entry[];
/**
 * Format the name of a log. A log's full name is in the format of
 * 'projects/{projectId}/logs/{logName}'.
 *
 * @param projectId
 * @param name
 */
export declare function formatLogName(projectId: string, name: string): string;
